// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Protected item model properties. </summary>
    public partial class DataReplicationProtectedItemProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataReplicationProtectedItemProperties"/>. </summary>
        /// <param name="policyName"> Gets or sets the policy name. </param>
        /// <param name="replicationExtensionName"> Gets or sets the replication extension name. </param>
        /// <param name="customProperties">
        /// Protected item model custom properties.
        /// Please note <see cref="ProtectedItemModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="HyperVToAzStackHciProtectedItemModelCustomProperties"/>, <see cref="GeneralProtectedItemModelCustomProperties"/> and <see cref="VMwareToAzStackHciProtectedItemModelCustomProperties"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="policyName"/>, <paramref name="replicationExtensionName"/> or <paramref name="customProperties"/> is null. </exception>
        public DataReplicationProtectedItemProperties(string policyName, string replicationExtensionName, ProtectedItemModelCustomProperties customProperties)
        {
            Argument.AssertNotNull(policyName, nameof(policyName));
            Argument.AssertNotNull(replicationExtensionName, nameof(replicationExtensionName));
            Argument.AssertNotNull(customProperties, nameof(customProperties));

            PolicyName = policyName;
            ReplicationExtensionName = replicationExtensionName;
            AllowedJobs = new ChangeTrackingList<string>();
            HealthErrors = new ChangeTrackingList<DataReplicationHealthErrorInfo>();
            CustomProperties = customProperties;
        }

        /// <summary> Initializes a new instance of <see cref="DataReplicationProtectedItemProperties"/>. </summary>
        /// <param name="policyName"> Gets or sets the policy name. </param>
        /// <param name="replicationExtensionName"> Gets or sets the replication extension name. </param>
        /// <param name="correlationId"> Gets or sets the protected item correlation Id. </param>
        /// <param name="provisioningState"> Gets or sets the provisioning state of the Dra. </param>
        /// <param name="protectionState"> Gets or sets the protection state. </param>
        /// <param name="protectionStateDescription"> Gets or sets the protection state description. </param>
        /// <param name="testFailoverState"> Gets or sets the test failover state. </param>
        /// <param name="testFailoverStateDescription"> Gets or sets the Test failover state description. </param>
        /// <param name="resynchronizationState"> Gets or sets the resynchronization state. </param>
        /// <param name="fabricObjectId"> Gets or sets the fabric object Id. </param>
        /// <param name="fabricObjectName"> Gets or sets the fabric object name. </param>
        /// <param name="sourceFabricProviderId"> Gets or sets the source fabric provider Id. </param>
        /// <param name="targetFabricProviderId"> Gets or sets the target fabric provider Id. </param>
        /// <param name="fabricId"> Gets or sets the fabric Id. </param>
        /// <param name="targetFabricId"> Gets or sets the target fabric Id. </param>
        /// <param name="draId"> Gets or sets the DRA Id. </param>
        /// <param name="targetDraId"> Gets or sets the target DRA Id. </param>
        /// <param name="isResyncRequired"> Gets or sets a value indicating whether resynchronization is required or not. </param>
        /// <param name="lastSuccessfulPlannedFailoverOn"> Gets or sets the Last successful planned failover time. </param>
        /// <param name="lastSuccessfulUnplannedFailoverOn"> Gets or sets the Last successful unplanned failover time. </param>
        /// <param name="lastSuccessfulTestFailoverOn"> Gets or sets the Last successful test failover time. </param>
        /// <param name="currentJob"> Protected item job properties. </param>
        /// <param name="allowedJobs"> Gets or sets the allowed scenarios on the protected item. </param>
        /// <param name="lastFailedEnableProtectionJob"> Protected item job properties. </param>
        /// <param name="lastFailedPlannedFailoverJob"> Protected item job properties. </param>
        /// <param name="lastTestFailoverJob"> Protected item job properties. </param>
        /// <param name="replicationHealth"> Gets or sets protected item replication health. </param>
        /// <param name="healthErrors"> Gets or sets the list of health errors. </param>
        /// <param name="customProperties">
        /// Protected item model custom properties.
        /// Please note <see cref="ProtectedItemModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="HyperVToAzStackHciProtectedItemModelCustomProperties"/>, <see cref="GeneralProtectedItemModelCustomProperties"/> and <see cref="VMwareToAzStackHciProtectedItemModelCustomProperties"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataReplicationProtectedItemProperties(string policyName, string replicationExtensionName, string correlationId, DataReplicationProvisioningState? provisioningState, DataReplicationProtectionState? protectionState, string protectionStateDescription, DataReplicationTestFailoverState? testFailoverState, string testFailoverStateDescription, DataReplicationResynchronizationState? resynchronizationState, string fabricObjectId, string fabricObjectName, string sourceFabricProviderId, string targetFabricProviderId, string fabricId, string targetFabricId, string draId, string targetDraId, bool? isResyncRequired, DateTimeOffset? lastSuccessfulPlannedFailoverOn, DateTimeOffset? lastSuccessfulUnplannedFailoverOn, DateTimeOffset? lastSuccessfulTestFailoverOn, ProtectedItemJobProperties currentJob, IReadOnlyList<string> allowedJobs, ProtectedItemJobProperties lastFailedEnableProtectionJob, ProtectedItemJobProperties lastFailedPlannedFailoverJob, ProtectedItemJobProperties lastTestFailoverJob, DataReplicationHealthStatus? replicationHealth, IReadOnlyList<DataReplicationHealthErrorInfo> healthErrors, ProtectedItemModelCustomProperties customProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PolicyName = policyName;
            ReplicationExtensionName = replicationExtensionName;
            CorrelationId = correlationId;
            ProvisioningState = provisioningState;
            ProtectionState = protectionState;
            ProtectionStateDescription = protectionStateDescription;
            TestFailoverState = testFailoverState;
            TestFailoverStateDescription = testFailoverStateDescription;
            ResynchronizationState = resynchronizationState;
            FabricObjectId = fabricObjectId;
            FabricObjectName = fabricObjectName;
            SourceFabricProviderId = sourceFabricProviderId;
            TargetFabricProviderId = targetFabricProviderId;
            FabricId = fabricId;
            TargetFabricId = targetFabricId;
            DraId = draId;
            TargetDraId = targetDraId;
            IsResyncRequired = isResyncRequired;
            LastSuccessfulPlannedFailoverOn = lastSuccessfulPlannedFailoverOn;
            LastSuccessfulUnplannedFailoverOn = lastSuccessfulUnplannedFailoverOn;
            LastSuccessfulTestFailoverOn = lastSuccessfulTestFailoverOn;
            CurrentJob = currentJob;
            AllowedJobs = allowedJobs;
            LastFailedEnableProtectionJob = lastFailedEnableProtectionJob;
            LastFailedPlannedFailoverJob = lastFailedPlannedFailoverJob;
            LastTestFailoverJob = lastTestFailoverJob;
            ReplicationHealth = replicationHealth;
            HealthErrors = healthErrors;
            CustomProperties = customProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataReplicationProtectedItemProperties"/> for deserialization. </summary>
        internal DataReplicationProtectedItemProperties()
        {
        }

        /// <summary> Gets or sets the policy name. </summary>
        public string PolicyName { get; set; }
        /// <summary> Gets or sets the replication extension name. </summary>
        public string ReplicationExtensionName { get; set; }
        /// <summary> Gets or sets the protected item correlation Id. </summary>
        public string CorrelationId { get; }
        /// <summary> Gets or sets the provisioning state of the Dra. </summary>
        public DataReplicationProvisioningState? ProvisioningState { get; }
        /// <summary> Gets or sets the protection state. </summary>
        public DataReplicationProtectionState? ProtectionState { get; }
        /// <summary> Gets or sets the protection state description. </summary>
        public string ProtectionStateDescription { get; }
        /// <summary> Gets or sets the test failover state. </summary>
        public DataReplicationTestFailoverState? TestFailoverState { get; }
        /// <summary> Gets or sets the Test failover state description. </summary>
        public string TestFailoverStateDescription { get; }
        /// <summary> Gets or sets the resynchronization state. </summary>
        public DataReplicationResynchronizationState? ResynchronizationState { get; }
        /// <summary> Gets or sets the fabric object Id. </summary>
        public string FabricObjectId { get; }
        /// <summary> Gets or sets the fabric object name. </summary>
        public string FabricObjectName { get; }
        /// <summary> Gets or sets the source fabric provider Id. </summary>
        public string SourceFabricProviderId { get; }
        /// <summary> Gets or sets the target fabric provider Id. </summary>
        public string TargetFabricProviderId { get; }
        /// <summary> Gets or sets the fabric Id. </summary>
        public string FabricId { get; }
        /// <summary> Gets or sets the target fabric Id. </summary>
        public string TargetFabricId { get; }
        /// <summary> Gets or sets the DRA Id. </summary>
        public string DraId { get; }
        /// <summary> Gets or sets the target DRA Id. </summary>
        public string TargetDraId { get; }
        /// <summary> Gets or sets a value indicating whether resynchronization is required or not. </summary>
        public bool? IsResyncRequired { get; }
        /// <summary> Gets or sets the Last successful planned failover time. </summary>
        public DateTimeOffset? LastSuccessfulPlannedFailoverOn { get; }
        /// <summary> Gets or sets the Last successful unplanned failover time. </summary>
        public DateTimeOffset? LastSuccessfulUnplannedFailoverOn { get; }
        /// <summary> Gets or sets the Last successful test failover time. </summary>
        public DateTimeOffset? LastSuccessfulTestFailoverOn { get; }
        /// <summary> Protected item job properties. </summary>
        public ProtectedItemJobProperties CurrentJob { get; }
        /// <summary> Gets or sets the allowed scenarios on the protected item. </summary>
        public IReadOnlyList<string> AllowedJobs { get; }
        /// <summary> Protected item job properties. </summary>
        public ProtectedItemJobProperties LastFailedEnableProtectionJob { get; }
        /// <summary> Protected item job properties. </summary>
        public ProtectedItemJobProperties LastFailedPlannedFailoverJob { get; }
        /// <summary> Protected item job properties. </summary>
        public ProtectedItemJobProperties LastTestFailoverJob { get; }
        /// <summary> Gets or sets protected item replication health. </summary>
        public DataReplicationHealthStatus? ReplicationHealth { get; }
        /// <summary> Gets or sets the list of health errors. </summary>
        public IReadOnlyList<DataReplicationHealthErrorInfo> HealthErrors { get; }
        /// <summary>
        /// Protected item model custom properties.
        /// Please note <see cref="ProtectedItemModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="HyperVToAzStackHciProtectedItemModelCustomProperties"/>, <see cref="GeneralProtectedItemModelCustomProperties"/> and <see cref="VMwareToAzStackHciProtectedItemModelCustomProperties"/>.
        /// </summary>
        public ProtectedItemModelCustomProperties CustomProperties { get; set; }
    }
}
