// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    public partial class DataReplicationProtectedItemProperties : IUtf8JsonSerializable, IJsonModel<DataReplicationProtectedItemProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataReplicationProtectedItemProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataReplicationProtectedItemProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataReplicationProtectedItemProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataReplicationProtectedItemProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("policyName"u8);
            writer.WriteStringValue(PolicyName);
            writer.WritePropertyName("replicationExtensionName"u8);
            writer.WriteStringValue(ReplicationExtensionName);
            if (options.Format != "W" && Optional.IsDefined(CorrelationId))
            {
                writer.WritePropertyName("correlationId"u8);
                writer.WriteStringValue(CorrelationId);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProtectionState))
            {
                writer.WritePropertyName("protectionState"u8);
                writer.WriteStringValue(ProtectionState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProtectionStateDescription))
            {
                writer.WritePropertyName("protectionStateDescription"u8);
                writer.WriteStringValue(ProtectionStateDescription);
            }
            if (options.Format != "W" && Optional.IsDefined(TestFailoverState))
            {
                writer.WritePropertyName("testFailoverState"u8);
                writer.WriteStringValue(TestFailoverState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(TestFailoverStateDescription))
            {
                writer.WritePropertyName("testFailoverStateDescription"u8);
                writer.WriteStringValue(TestFailoverStateDescription);
            }
            if (options.Format != "W" && Optional.IsDefined(ResynchronizationState))
            {
                writer.WritePropertyName("resynchronizationState"u8);
                writer.WriteStringValue(ResynchronizationState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(FabricObjectId))
            {
                writer.WritePropertyName("fabricObjectId"u8);
                writer.WriteStringValue(FabricObjectId);
            }
            if (options.Format != "W" && Optional.IsDefined(FabricObjectName))
            {
                writer.WritePropertyName("fabricObjectName"u8);
                writer.WriteStringValue(FabricObjectName);
            }
            if (options.Format != "W" && Optional.IsDefined(SourceFabricProviderId))
            {
                writer.WritePropertyName("sourceFabricProviderId"u8);
                writer.WriteStringValue(SourceFabricProviderId);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetFabricProviderId))
            {
                writer.WritePropertyName("targetFabricProviderId"u8);
                writer.WriteStringValue(TargetFabricProviderId);
            }
            if (options.Format != "W" && Optional.IsDefined(FabricId))
            {
                writer.WritePropertyName("fabricId"u8);
                writer.WriteStringValue(FabricId);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetFabricId))
            {
                writer.WritePropertyName("targetFabricId"u8);
                writer.WriteStringValue(TargetFabricId);
            }
            if (options.Format != "W" && Optional.IsDefined(DraId))
            {
                writer.WritePropertyName("draId"u8);
                writer.WriteStringValue(DraId);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetDraId))
            {
                writer.WritePropertyName("targetDraId"u8);
                writer.WriteStringValue(TargetDraId);
            }
            if (options.Format != "W" && Optional.IsDefined(IsResyncRequired))
            {
                writer.WritePropertyName("resyncRequired"u8);
                writer.WriteBooleanValue(IsResyncRequired.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(LastSuccessfulPlannedFailoverOn))
            {
                writer.WritePropertyName("lastSuccessfulPlannedFailoverTime"u8);
                writer.WriteStringValue(LastSuccessfulPlannedFailoverOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastSuccessfulUnplannedFailoverOn))
            {
                writer.WritePropertyName("lastSuccessfulUnplannedFailoverTime"u8);
                writer.WriteStringValue(LastSuccessfulUnplannedFailoverOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastSuccessfulTestFailoverOn))
            {
                writer.WritePropertyName("lastSuccessfulTestFailoverTime"u8);
                writer.WriteStringValue(LastSuccessfulTestFailoverOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentJob))
            {
                writer.WritePropertyName("currentJob"u8);
                writer.WriteObjectValue(CurrentJob, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(AllowedJobs))
            {
                writer.WritePropertyName("allowedJobs"u8);
                writer.WriteStartArray();
                foreach (var item in AllowedJobs)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(LastFailedEnableProtectionJob))
            {
                writer.WritePropertyName("lastFailedEnableProtectionJob"u8);
                writer.WriteObjectValue(LastFailedEnableProtectionJob, options);
            }
            if (options.Format != "W" && Optional.IsDefined(LastFailedPlannedFailoverJob))
            {
                writer.WritePropertyName("lastFailedPlannedFailoverJob"u8);
                writer.WriteObjectValue(LastFailedPlannedFailoverJob, options);
            }
            if (options.Format != "W" && Optional.IsDefined(LastTestFailoverJob))
            {
                writer.WritePropertyName("lastTestFailoverJob"u8);
                writer.WriteObjectValue(LastTestFailoverJob, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ReplicationHealth))
            {
                writer.WritePropertyName("replicationHealth"u8);
                writer.WriteStringValue(ReplicationHealth.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(HealthErrors))
            {
                writer.WritePropertyName("healthErrors"u8);
                writer.WriteStartArray();
                foreach (var item in HealthErrors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("customProperties"u8);
            writer.WriteObjectValue(CustomProperties, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DataReplicationProtectedItemProperties IJsonModel<DataReplicationProtectedItemProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataReplicationProtectedItemProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataReplicationProtectedItemProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataReplicationProtectedItemProperties(document.RootElement, options);
        }

        internal static DataReplicationProtectedItemProperties DeserializeDataReplicationProtectedItemProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string policyName = default;
            string replicationExtensionName = default;
            string correlationId = default;
            DataReplicationProvisioningState? provisioningState = default;
            DataReplicationProtectionState? protectionState = default;
            string protectionStateDescription = default;
            DataReplicationTestFailoverState? testFailoverState = default;
            string testFailoverStateDescription = default;
            DataReplicationResynchronizationState? resynchronizationState = default;
            string fabricObjectId = default;
            string fabricObjectName = default;
            string sourceFabricProviderId = default;
            string targetFabricProviderId = default;
            string fabricId = default;
            string targetFabricId = default;
            string draId = default;
            string targetDraId = default;
            bool? resyncRequired = default;
            DateTimeOffset? lastSuccessfulPlannedFailoverTime = default;
            DateTimeOffset? lastSuccessfulUnplannedFailoverTime = default;
            DateTimeOffset? lastSuccessfulTestFailoverTime = default;
            ProtectedItemJobProperties currentJob = default;
            IReadOnlyList<string> allowedJobs = default;
            ProtectedItemJobProperties lastFailedEnableProtectionJob = default;
            ProtectedItemJobProperties lastFailedPlannedFailoverJob = default;
            ProtectedItemJobProperties lastTestFailoverJob = default;
            DataReplicationHealthStatus? replicationHealth = default;
            IReadOnlyList<DataReplicationHealthErrorInfo> healthErrors = default;
            ProtectedItemModelCustomProperties customProperties = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("policyName"u8))
                {
                    policyName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("replicationExtensionName"u8))
                {
                    replicationExtensionName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("correlationId"u8))
                {
                    correlationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new DataReplicationProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("protectionState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    protectionState = new DataReplicationProtectionState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("protectionStateDescription"u8))
                {
                    protectionStateDescription = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("testFailoverState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    testFailoverState = new DataReplicationTestFailoverState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("testFailoverStateDescription"u8))
                {
                    testFailoverStateDescription = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resynchronizationState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resynchronizationState = new DataReplicationResynchronizationState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("fabricObjectId"u8))
                {
                    fabricObjectId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fabricObjectName"u8))
                {
                    fabricObjectName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceFabricProviderId"u8))
                {
                    sourceFabricProviderId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetFabricProviderId"u8))
                {
                    targetFabricProviderId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fabricId"u8))
                {
                    fabricId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetFabricId"u8))
                {
                    targetFabricId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("draId"u8))
                {
                    draId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetDraId"u8))
                {
                    targetDraId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resyncRequired"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncRequired = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("lastSuccessfulPlannedFailoverTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastSuccessfulPlannedFailoverTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastSuccessfulUnplannedFailoverTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastSuccessfulUnplannedFailoverTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastSuccessfulTestFailoverTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastSuccessfulTestFailoverTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("currentJob"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    currentJob = ProtectedItemJobProperties.DeserializeProtectedItemJobProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("allowedJobs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    allowedJobs = array;
                    continue;
                }
                if (property.NameEquals("lastFailedEnableProtectionJob"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastFailedEnableProtectionJob = ProtectedItemJobProperties.DeserializeProtectedItemJobProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("lastFailedPlannedFailoverJob"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastFailedPlannedFailoverJob = ProtectedItemJobProperties.DeserializeProtectedItemJobProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("lastTestFailoverJob"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastTestFailoverJob = ProtectedItemJobProperties.DeserializeProtectedItemJobProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("replicationHealth"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    replicationHealth = new DataReplicationHealthStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("healthErrors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DataReplicationHealthErrorInfo> array = new List<DataReplicationHealthErrorInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DataReplicationHealthErrorInfo.DeserializeDataReplicationHealthErrorInfo(item, options));
                    }
                    healthErrors = array;
                    continue;
                }
                if (property.NameEquals("customProperties"u8))
                {
                    customProperties = ProtectedItemModelCustomProperties.DeserializeProtectedItemModelCustomProperties(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataReplicationProtectedItemProperties(
                policyName,
                replicationExtensionName,
                correlationId,
                provisioningState,
                protectionState,
                protectionStateDescription,
                testFailoverState,
                testFailoverStateDescription,
                resynchronizationState,
                fabricObjectId,
                fabricObjectName,
                sourceFabricProviderId,
                targetFabricProviderId,
                fabricId,
                targetFabricId,
                draId,
                targetDraId,
                resyncRequired,
                lastSuccessfulPlannedFailoverTime,
                lastSuccessfulUnplannedFailoverTime,
                lastSuccessfulTestFailoverTime,
                currentJob,
                allowedJobs ?? new ChangeTrackingList<string>(),
                lastFailedEnableProtectionJob,
                lastFailedPlannedFailoverJob,
                lastTestFailoverJob,
                replicationHealth,
                healthErrors ?? new ChangeTrackingList<DataReplicationHealthErrorInfo>(),
                customProperties,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DataReplicationProtectedItemProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataReplicationProtectedItemProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DataReplicationProtectedItemProperties)} does not support writing '{options.Format}' format.");
            }
        }

        DataReplicationProtectedItemProperties IPersistableModel<DataReplicationProtectedItemProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataReplicationProtectedItemProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataReplicationProtectedItemProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataReplicationProtectedItemProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataReplicationProtectedItemProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
