// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Gets or sets the fabric health. </summary>
    public readonly partial struct DataReplicationHealthStatus : IEquatable<DataReplicationHealthStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataReplicationHealthStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataReplicationHealthStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NormalValue = "Normal";
        private const string WarningValue = "Warning";
        private const string CriticalValue = "Critical";

        /// <summary> Normal. </summary>
        public static DataReplicationHealthStatus Normal { get; } = new DataReplicationHealthStatus(NormalValue);
        /// <summary> Warning. </summary>
        public static DataReplicationHealthStatus Warning { get; } = new DataReplicationHealthStatus(WarningValue);
        /// <summary> Critical. </summary>
        public static DataReplicationHealthStatus Critical { get; } = new DataReplicationHealthStatus(CriticalValue);
        /// <summary> Determines if two <see cref="DataReplicationHealthStatus"/> values are the same. </summary>
        public static bool operator ==(DataReplicationHealthStatus left, DataReplicationHealthStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataReplicationHealthStatus"/> values are not the same. </summary>
        public static bool operator !=(DataReplicationHealthStatus left, DataReplicationHealthStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataReplicationHealthStatus"/>. </summary>
        public static implicit operator DataReplicationHealthStatus(string value) => new DataReplicationHealthStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataReplicationHealthStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataReplicationHealthStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
