// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> AzStackHCI fabric model custom properties. </summary>
    public partial class AzStackHciFabricModelCustomProperties : FabricModelCustomProperties
    {
        /// <summary> Initializes a new instance of <see cref="AzStackHciFabricModelCustomProperties"/>. </summary>
        /// <param name="azStackHciSiteId"> Gets or sets the ARM Id of the AzStackHCI site. </param>
        /// <param name="cluster"> AzStackHCI cluster properties. </param>
        /// <param name="migrationSolutionId"> Gets or sets the Migration solution ARM Id. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="azStackHciSiteId"/>, <paramref name="cluster"/> or <paramref name="migrationSolutionId"/> is null. </exception>
        public AzStackHciFabricModelCustomProperties(ResourceIdentifier azStackHciSiteId, AzStackHciClusterProperties cluster, ResourceIdentifier migrationSolutionId)
        {
            Argument.AssertNotNull(azStackHciSiteId, nameof(azStackHciSiteId));
            Argument.AssertNotNull(cluster, nameof(cluster));
            Argument.AssertNotNull(migrationSolutionId, nameof(migrationSolutionId));

            AzStackHciSiteId = azStackHciSiteId;
            ApplianceName = new ChangeTrackingList<string>();
            Cluster = cluster;
            MigrationSolutionId = migrationSolutionId;
            InstanceType = "AzStackHCI";
        }

        /// <summary> Initializes a new instance of <see cref="AzStackHciFabricModelCustomProperties"/>. </summary>
        /// <param name="instanceType"> Gets or sets the instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="azStackHciSiteId"> Gets or sets the ARM Id of the AzStackHCI site. </param>
        /// <param name="applianceName"> Gets or sets the Appliance name. </param>
        /// <param name="cluster"> AzStackHCI cluster properties. </param>
        /// <param name="fabricResourceId"> Gets or sets the fabric resource Id. </param>
        /// <param name="fabricContainerId"> Gets or sets the fabric container Id. </param>
        /// <param name="migrationSolutionId"> Gets or sets the Migration solution ARM Id. </param>
        /// <param name="migrationHubUri"> Gets or sets the migration hub Uri. </param>
        internal AzStackHciFabricModelCustomProperties(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier azStackHciSiteId, IReadOnlyList<string> applianceName, AzStackHciClusterProperties cluster, ResourceIdentifier fabricResourceId, string fabricContainerId, ResourceIdentifier migrationSolutionId, Uri migrationHubUri) : base(instanceType, serializedAdditionalRawData)
        {
            AzStackHciSiteId = azStackHciSiteId;
            ApplianceName = applianceName;
            Cluster = cluster;
            FabricResourceId = fabricResourceId;
            FabricContainerId = fabricContainerId;
            MigrationSolutionId = migrationSolutionId;
            MigrationHubUri = migrationHubUri;
            InstanceType = instanceType ?? "AzStackHCI";
        }

        /// <summary> Initializes a new instance of <see cref="AzStackHciFabricModelCustomProperties"/> for deserialization. </summary>
        internal AzStackHciFabricModelCustomProperties()
        {
        }

        /// <summary> Gets or sets the ARM Id of the AzStackHCI site. </summary>
        public ResourceIdentifier AzStackHciSiteId { get; set; }
        /// <summary> Gets or sets the Appliance name. </summary>
        public IReadOnlyList<string> ApplianceName { get; }
        /// <summary> AzStackHCI cluster properties. </summary>
        public AzStackHciClusterProperties Cluster { get; set; }
        /// <summary> Gets or sets the fabric resource Id. </summary>
        public ResourceIdentifier FabricResourceId { get; }
        /// <summary> Gets or sets the fabric container Id. </summary>
        public string FabricContainerId { get; }
        /// <summary> Gets or sets the Migration solution ARM Id. </summary>
        public ResourceIdentifier MigrationSolutionId { get; set; }
        /// <summary> Gets or sets the migration hub Uri. </summary>
        public Uri MigrationHubUri { get; }
    }
}
