// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.RecoveryServicesDataReplication.Models;

namespace Azure.ResourceManager.RecoveryServicesDataReplication
{
    internal class PlannedFailoverModelOperationSource : IOperationSource<PlannedFailoverModel>
    {
        PlannedFailoverModel IOperationSource<PlannedFailoverModel>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return PlannedFailoverModel.DeserializePlannedFailoverModel(document.RootElement);
        }

        async ValueTask<PlannedFailoverModel> IOperationSource<PlannedFailoverModel>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return PlannedFailoverModel.DeserializePlannedFailoverModel(document.RootElement);
        }
    }
}
