// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication
{
    internal class DataReplicationVaultOperationSource : IOperationSource<DataReplicationVaultResource>
    {
        private readonly ArmClient _client;

        internal DataReplicationVaultOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataReplicationVaultResource IOperationSource<DataReplicationVaultResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataReplicationVaultData.DeserializeDataReplicationVaultData(document.RootElement);
            return new DataReplicationVaultResource(_client, data);
        }

        async ValueTask<DataReplicationVaultResource> IOperationSource<DataReplicationVaultResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataReplicationVaultData.DeserializeDataReplicationVaultData(document.RootElement);
            return new DataReplicationVaultResource(_client, data);
        }
    }
}
