// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication
{
    internal class DataReplicationReplicationExtensionOperationSource : IOperationSource<DataReplicationReplicationExtensionResource>
    {
        private readonly ArmClient _client;

        internal DataReplicationReplicationExtensionOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataReplicationReplicationExtensionResource IOperationSource<DataReplicationReplicationExtensionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataReplicationReplicationExtensionData.DeserializeDataReplicationReplicationExtensionData(document.RootElement);
            return new DataReplicationReplicationExtensionResource(_client, data);
        }

        async ValueTask<DataReplicationReplicationExtensionResource> IOperationSource<DataReplicationReplicationExtensionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataReplicationReplicationExtensionData.DeserializeDataReplicationReplicationExtensionData(document.RootElement);
            return new DataReplicationReplicationExtensionResource(_client, data);
        }
    }
}
