// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication
{
    internal class DataReplicationFabricOperationSource : IOperationSource<DataReplicationFabricResource>
    {
        private readonly ArmClient _client;

        internal DataReplicationFabricOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataReplicationFabricResource IOperationSource<DataReplicationFabricResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataReplicationFabricData.DeserializeDataReplicationFabricData(document.RootElement);
            return new DataReplicationFabricResource(_client, data);
        }

        async ValueTask<DataReplicationFabricResource> IOperationSource<DataReplicationFabricResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataReplicationFabricData.DeserializeDataReplicationFabricData(document.RootElement);
            return new DataReplicationFabricResource(_client, data);
        }
    }
}
