// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication
{
    internal class DataReplicationDraOperationSource : IOperationSource<DataReplicationDraResource>
    {
        private readonly ArmClient _client;

        internal DataReplicationDraOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataReplicationDraResource IOperationSource<DataReplicationDraResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataReplicationDraData.DeserializeDataReplicationDraData(document.RootElement);
            return new DataReplicationDraResource(_client, data);
        }

        async ValueTask<DataReplicationDraResource> IOperationSource<DataReplicationDraResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataReplicationDraData.DeserializeDataReplicationDraData(document.RootElement);
            return new DataReplicationDraResource(_client, data);
        }
    }
}
