// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.RecoveryServicesDataReplication
{
    /// <summary>
    /// A class representing a collection of <see cref="DataReplicationEventResource"/> and their operations.
    /// Each <see cref="DataReplicationEventResource"/> in the collection will belong to the same instance of <see cref="DataReplicationVaultResource"/>.
    /// To get a <see cref="DataReplicationEventCollection"/> instance call the GetDataReplicationEvents method from an instance of <see cref="DataReplicationVaultResource"/>.
    /// </summary>
    public partial class DataReplicationEventCollection : ArmCollection, IEnumerable<DataReplicationEventResource>, IAsyncEnumerable<DataReplicationEventResource>
    {
        private readonly ClientDiagnostics _dataReplicationEventEventClientDiagnostics;
        private readonly EventRestOperations _dataReplicationEventEventRestClient;

        /// <summary> Initializes a new instance of the <see cref="DataReplicationEventCollection"/> class for mocking. </summary>
        protected DataReplicationEventCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DataReplicationEventCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DataReplicationEventCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _dataReplicationEventEventClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.RecoveryServicesDataReplication", DataReplicationEventResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DataReplicationEventResource.ResourceType, out string dataReplicationEventEventApiVersion);
            _dataReplicationEventEventRestClient = new EventRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, dataReplicationEventEventApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != DataReplicationVaultResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, DataReplicationVaultResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the details of the event.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/events/{eventName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Event_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEventResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="eventName"> The event name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="eventName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="eventName"/> is null. </exception>
        public virtual async Task<Response<DataReplicationEventResource>> GetAsync(string eventName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(eventName, nameof(eventName));

            using var scope = _dataReplicationEventEventClientDiagnostics.CreateScope("DataReplicationEventCollection.Get");
            scope.Start();
            try
            {
                var response = await _dataReplicationEventEventRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, eventName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataReplicationEventResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the event.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/events/{eventName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Event_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEventResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="eventName"> The event name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="eventName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="eventName"/> is null. </exception>
        public virtual Response<DataReplicationEventResource> Get(string eventName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(eventName, nameof(eventName));

            using var scope = _dataReplicationEventEventClientDiagnostics.CreateScope("DataReplicationEventCollection.Get");
            scope.Start();
            try
            {
                var response = _dataReplicationEventEventRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, eventName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataReplicationEventResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the list of events in the given vault.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/events</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Event_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEventResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> Filter string. </param>
        /// <param name="continuationToken"> Continuation token. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DataReplicationEventResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DataReplicationEventResource> GetAllAsync(string filter = null, string continuationToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dataReplicationEventEventRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, continuationToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dataReplicationEventEventRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, continuationToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DataReplicationEventResource(Client, DataReplicationEventData.DeserializeDataReplicationEventData(e)), _dataReplicationEventEventClientDiagnostics, Pipeline, "DataReplicationEventCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets the list of events in the given vault.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/events</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Event_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEventResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> Filter string. </param>
        /// <param name="continuationToken"> Continuation token. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DataReplicationEventResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DataReplicationEventResource> GetAll(string filter = null, string continuationToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dataReplicationEventEventRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, continuationToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dataReplicationEventEventRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, continuationToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DataReplicationEventResource(Client, DataReplicationEventData.DeserializeDataReplicationEventData(e)), _dataReplicationEventEventClientDiagnostics, Pipeline, "DataReplicationEventCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/events/{eventName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Event_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEventResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="eventName"> The event name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="eventName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="eventName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string eventName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(eventName, nameof(eventName));

            using var scope = _dataReplicationEventEventClientDiagnostics.CreateScope("DataReplicationEventCollection.Exists");
            scope.Start();
            try
            {
                var response = await _dataReplicationEventEventRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, eventName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/events/{eventName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Event_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEventResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="eventName"> The event name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="eventName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="eventName"/> is null. </exception>
        public virtual Response<bool> Exists(string eventName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(eventName, nameof(eventName));

            using var scope = _dataReplicationEventEventClientDiagnostics.CreateScope("DataReplicationEventCollection.Exists");
            scope.Start();
            try
            {
                var response = _dataReplicationEventEventRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, eventName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/events/{eventName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Event_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEventResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="eventName"> The event name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="eventName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="eventName"/> is null. </exception>
        public virtual async Task<NullableResponse<DataReplicationEventResource>> GetIfExistsAsync(string eventName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(eventName, nameof(eventName));

            using var scope = _dataReplicationEventEventClientDiagnostics.CreateScope("DataReplicationEventCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _dataReplicationEventEventRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, eventName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DataReplicationEventResource>(response.GetRawResponse());
                return Response.FromValue(new DataReplicationEventResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/events/{eventName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Event_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEventResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="eventName"> The event name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="eventName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="eventName"/> is null. </exception>
        public virtual NullableResponse<DataReplicationEventResource> GetIfExists(string eventName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(eventName, nameof(eventName));

            using var scope = _dataReplicationEventEventClientDiagnostics.CreateScope("DataReplicationEventCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _dataReplicationEventEventRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, eventName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DataReplicationEventResource>(response.GetRawResponse());
                return Response.FromValue(new DataReplicationEventResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<DataReplicationEventResource> IEnumerable<DataReplicationEventResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<DataReplicationEventResource> IAsyncEnumerable<DataReplicationEventResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
