// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.RecoveryServicesDataReplication
{
    /// <summary>
    /// A class representing a collection of <see cref="DataReplicationEmailConfigurationResource"/> and their operations.
    /// Each <see cref="DataReplicationEmailConfigurationResource"/> in the collection will belong to the same instance of <see cref="DataReplicationVaultResource"/>.
    /// To get a <see cref="DataReplicationEmailConfigurationCollection"/> instance call the GetDataReplicationEmailConfigurations method from an instance of <see cref="DataReplicationVaultResource"/>.
    /// </summary>
    public partial class DataReplicationEmailConfigurationCollection : ArmCollection, IEnumerable<DataReplicationEmailConfigurationResource>, IAsyncEnumerable<DataReplicationEmailConfigurationResource>
    {
        private readonly ClientDiagnostics _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics;
        private readonly EmailConfigurationRestOperations _dataReplicationEmailConfigurationEmailConfigurationRestClient;

        /// <summary> Initializes a new instance of the <see cref="DataReplicationEmailConfigurationCollection"/> class for mocking. </summary>
        protected DataReplicationEmailConfigurationCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DataReplicationEmailConfigurationCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DataReplicationEmailConfigurationCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.RecoveryServicesDataReplication", DataReplicationEmailConfigurationResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DataReplicationEmailConfigurationResource.ResourceType, out string dataReplicationEmailConfigurationEmailConfigurationApiVersion);
            _dataReplicationEmailConfigurationEmailConfigurationRestClient = new EmailConfigurationRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, dataReplicationEmailConfigurationEmailConfigurationApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != DataReplicationVaultResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, DataReplicationVaultResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates an alert configuration setting for the given vault.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings/{emailConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailConfiguration_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEmailConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="emailConfigurationName"> The email configuration name. </param>
        /// <param name="data"> EmailConfiguration model. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="emailConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="emailConfigurationName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<DataReplicationEmailConfigurationResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string emailConfigurationName, DataReplicationEmailConfigurationData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(emailConfigurationName, nameof(emailConfigurationName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics.CreateScope("DataReplicationEmailConfigurationCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _dataReplicationEmailConfigurationEmailConfigurationRestClient.CreateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, emailConfigurationName, data, cancellationToken).ConfigureAwait(false);
                var uri = _dataReplicationEmailConfigurationEmailConfigurationRestClient.CreateCreateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, emailConfigurationName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new RecoveryServicesDataReplicationArmOperation<DataReplicationEmailConfigurationResource>(Response.FromValue(new DataReplicationEmailConfigurationResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates an alert configuration setting for the given vault.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings/{emailConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailConfiguration_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEmailConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="emailConfigurationName"> The email configuration name. </param>
        /// <param name="data"> EmailConfiguration model. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="emailConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="emailConfigurationName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<DataReplicationEmailConfigurationResource> CreateOrUpdate(WaitUntil waitUntil, string emailConfigurationName, DataReplicationEmailConfigurationData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(emailConfigurationName, nameof(emailConfigurationName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics.CreateScope("DataReplicationEmailConfigurationCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _dataReplicationEmailConfigurationEmailConfigurationRestClient.Create(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, emailConfigurationName, data, cancellationToken);
                var uri = _dataReplicationEmailConfigurationEmailConfigurationRestClient.CreateCreateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, emailConfigurationName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new RecoveryServicesDataReplicationArmOperation<DataReplicationEmailConfigurationResource>(Response.FromValue(new DataReplicationEmailConfigurationResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the alert configuration setting.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings/{emailConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEmailConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="emailConfigurationName"> The email configuration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="emailConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="emailConfigurationName"/> is null. </exception>
        public virtual async Task<Response<DataReplicationEmailConfigurationResource>> GetAsync(string emailConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(emailConfigurationName, nameof(emailConfigurationName));

            using var scope = _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics.CreateScope("DataReplicationEmailConfigurationCollection.Get");
            scope.Start();
            try
            {
                var response = await _dataReplicationEmailConfigurationEmailConfigurationRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, emailConfigurationName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataReplicationEmailConfigurationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the alert configuration setting.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings/{emailConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEmailConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="emailConfigurationName"> The email configuration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="emailConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="emailConfigurationName"/> is null. </exception>
        public virtual Response<DataReplicationEmailConfigurationResource> Get(string emailConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(emailConfigurationName, nameof(emailConfigurationName));

            using var scope = _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics.CreateScope("DataReplicationEmailConfigurationCollection.Get");
            scope.Start();
            try
            {
                var response = _dataReplicationEmailConfigurationEmailConfigurationRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, emailConfigurationName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataReplicationEmailConfigurationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the list of alert configuration settings for the given vault.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailConfiguration_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEmailConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DataReplicationEmailConfigurationResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DataReplicationEmailConfigurationResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dataReplicationEmailConfigurationEmailConfigurationRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dataReplicationEmailConfigurationEmailConfigurationRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DataReplicationEmailConfigurationResource(Client, DataReplicationEmailConfigurationData.DeserializeDataReplicationEmailConfigurationData(e)), _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics, Pipeline, "DataReplicationEmailConfigurationCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets the list of alert configuration settings for the given vault.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailConfiguration_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEmailConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DataReplicationEmailConfigurationResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DataReplicationEmailConfigurationResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dataReplicationEmailConfigurationEmailConfigurationRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dataReplicationEmailConfigurationEmailConfigurationRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DataReplicationEmailConfigurationResource(Client, DataReplicationEmailConfigurationData.DeserializeDataReplicationEmailConfigurationData(e)), _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics, Pipeline, "DataReplicationEmailConfigurationCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings/{emailConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEmailConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="emailConfigurationName"> The email configuration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="emailConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="emailConfigurationName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string emailConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(emailConfigurationName, nameof(emailConfigurationName));

            using var scope = _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics.CreateScope("DataReplicationEmailConfigurationCollection.Exists");
            scope.Start();
            try
            {
                var response = await _dataReplicationEmailConfigurationEmailConfigurationRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, emailConfigurationName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings/{emailConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEmailConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="emailConfigurationName"> The email configuration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="emailConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="emailConfigurationName"/> is null. </exception>
        public virtual Response<bool> Exists(string emailConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(emailConfigurationName, nameof(emailConfigurationName));

            using var scope = _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics.CreateScope("DataReplicationEmailConfigurationCollection.Exists");
            scope.Start();
            try
            {
                var response = _dataReplicationEmailConfigurationEmailConfigurationRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, emailConfigurationName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings/{emailConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEmailConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="emailConfigurationName"> The email configuration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="emailConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="emailConfigurationName"/> is null. </exception>
        public virtual async Task<NullableResponse<DataReplicationEmailConfigurationResource>> GetIfExistsAsync(string emailConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(emailConfigurationName, nameof(emailConfigurationName));

            using var scope = _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics.CreateScope("DataReplicationEmailConfigurationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _dataReplicationEmailConfigurationEmailConfigurationRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, emailConfigurationName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DataReplicationEmailConfigurationResource>(response.GetRawResponse());
                return Response.FromValue(new DataReplicationEmailConfigurationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/alertSettings/{emailConfigurationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailConfiguration_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationEmailConfigurationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="emailConfigurationName"> The email configuration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="emailConfigurationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="emailConfigurationName"/> is null. </exception>
        public virtual NullableResponse<DataReplicationEmailConfigurationResource> GetIfExists(string emailConfigurationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(emailConfigurationName, nameof(emailConfigurationName));

            using var scope = _dataReplicationEmailConfigurationEmailConfigurationClientDiagnostics.CreateScope("DataReplicationEmailConfigurationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _dataReplicationEmailConfigurationEmailConfigurationRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, emailConfigurationName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DataReplicationEmailConfigurationResource>(response.GetRawResponse());
                return Response.FromValue(new DataReplicationEmailConfigurationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<DataReplicationEmailConfigurationResource> IEnumerable<DataReplicationEmailConfigurationResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<DataReplicationEmailConfigurationResource> IAsyncEnumerable<DataReplicationEmailConfigurationResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
