// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.RecoveryServicesDataReplication
{
    /// <summary>
    /// A class representing a collection of <see cref="DataReplicationDraResource"/> and their operations.
    /// Each <see cref="DataReplicationDraResource"/> in the collection will belong to the same instance of <see cref="DataReplicationFabricResource"/>.
    /// To get a <see cref="DataReplicationDraCollection"/> instance call the GetDataReplicationDras method from an instance of <see cref="DataReplicationFabricResource"/>.
    /// </summary>
    public partial class DataReplicationDraCollection : ArmCollection, IEnumerable<DataReplicationDraResource>, IAsyncEnumerable<DataReplicationDraResource>
    {
        private readonly ClientDiagnostics _dataReplicationDraDraClientDiagnostics;
        private readonly DraRestOperations _dataReplicationDraDraRestClient;

        /// <summary> Initializes a new instance of the <see cref="DataReplicationDraCollection"/> class for mocking. </summary>
        protected DataReplicationDraCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DataReplicationDraCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DataReplicationDraCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _dataReplicationDraDraClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.RecoveryServicesDataReplication", DataReplicationDraResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DataReplicationDraResource.ResourceType, out string dataReplicationDraDraApiVersion);
            _dataReplicationDraDraRestClient = new DraRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, dataReplicationDraDraApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != DataReplicationFabricResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, DataReplicationFabricResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates the fabric agent.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents/{fabricAgentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Dra_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationDraResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="fabricAgentName"> The fabric agent (Dra) name. </param>
        /// <param name="data"> Dra model. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fabricAgentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fabricAgentName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<DataReplicationDraResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string fabricAgentName, DataReplicationDraData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fabricAgentName, nameof(fabricAgentName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _dataReplicationDraDraClientDiagnostics.CreateScope("DataReplicationDraCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _dataReplicationDraDraRestClient.CreateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, fabricAgentName, data, cancellationToken).ConfigureAwait(false);
                var operation = new RecoveryServicesDataReplicationArmOperation<DataReplicationDraResource>(new DataReplicationDraOperationSource(Client), _dataReplicationDraDraClientDiagnostics, Pipeline, _dataReplicationDraDraRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, fabricAgentName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates the fabric agent.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents/{fabricAgentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Dra_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationDraResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="fabricAgentName"> The fabric agent (Dra) name. </param>
        /// <param name="data"> Dra model. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fabricAgentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fabricAgentName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<DataReplicationDraResource> CreateOrUpdate(WaitUntil waitUntil, string fabricAgentName, DataReplicationDraData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fabricAgentName, nameof(fabricAgentName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _dataReplicationDraDraClientDiagnostics.CreateScope("DataReplicationDraCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _dataReplicationDraDraRestClient.Create(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, fabricAgentName, data, cancellationToken);
                var operation = new RecoveryServicesDataReplicationArmOperation<DataReplicationDraResource>(new DataReplicationDraOperationSource(Client), _dataReplicationDraDraClientDiagnostics, Pipeline, _dataReplicationDraDraRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, fabricAgentName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the fabric agent.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents/{fabricAgentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Dra_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationDraResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fabricAgentName"> The fabric agent (Dra) name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fabricAgentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fabricAgentName"/> is null. </exception>
        public virtual async Task<Response<DataReplicationDraResource>> GetAsync(string fabricAgentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fabricAgentName, nameof(fabricAgentName));

            using var scope = _dataReplicationDraDraClientDiagnostics.CreateScope("DataReplicationDraCollection.Get");
            scope.Start();
            try
            {
                var response = await _dataReplicationDraDraRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, fabricAgentName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataReplicationDraResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the fabric agent.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents/{fabricAgentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Dra_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationDraResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fabricAgentName"> The fabric agent (Dra) name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fabricAgentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fabricAgentName"/> is null. </exception>
        public virtual Response<DataReplicationDraResource> Get(string fabricAgentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fabricAgentName, nameof(fabricAgentName));

            using var scope = _dataReplicationDraDraClientDiagnostics.CreateScope("DataReplicationDraCollection.Get");
            scope.Start();
            try
            {
                var response = _dataReplicationDraDraRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, fabricAgentName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataReplicationDraResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the list of fabric agents in the given fabric.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Dra_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationDraResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DataReplicationDraResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DataReplicationDraResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dataReplicationDraDraRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dataReplicationDraDraRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DataReplicationDraResource(Client, DataReplicationDraData.DeserializeDataReplicationDraData(e)), _dataReplicationDraDraClientDiagnostics, Pipeline, "DataReplicationDraCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets the list of fabric agents in the given fabric.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Dra_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationDraResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DataReplicationDraResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DataReplicationDraResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dataReplicationDraDraRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dataReplicationDraDraRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DataReplicationDraResource(Client, DataReplicationDraData.DeserializeDataReplicationDraData(e)), _dataReplicationDraDraClientDiagnostics, Pipeline, "DataReplicationDraCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents/{fabricAgentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Dra_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationDraResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fabricAgentName"> The fabric agent (Dra) name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fabricAgentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fabricAgentName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string fabricAgentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fabricAgentName, nameof(fabricAgentName));

            using var scope = _dataReplicationDraDraClientDiagnostics.CreateScope("DataReplicationDraCollection.Exists");
            scope.Start();
            try
            {
                var response = await _dataReplicationDraDraRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, fabricAgentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents/{fabricAgentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Dra_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationDraResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fabricAgentName"> The fabric agent (Dra) name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fabricAgentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fabricAgentName"/> is null. </exception>
        public virtual Response<bool> Exists(string fabricAgentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fabricAgentName, nameof(fabricAgentName));

            using var scope = _dataReplicationDraDraClientDiagnostics.CreateScope("DataReplicationDraCollection.Exists");
            scope.Start();
            try
            {
                var response = _dataReplicationDraDraRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, fabricAgentName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents/{fabricAgentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Dra_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationDraResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fabricAgentName"> The fabric agent (Dra) name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fabricAgentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fabricAgentName"/> is null. </exception>
        public virtual async Task<NullableResponse<DataReplicationDraResource>> GetIfExistsAsync(string fabricAgentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fabricAgentName, nameof(fabricAgentName));

            using var scope = _dataReplicationDraDraClientDiagnostics.CreateScope("DataReplicationDraCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _dataReplicationDraDraRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, fabricAgentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DataReplicationDraResource>(response.GetRawResponse());
                return Response.FromValue(new DataReplicationDraResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents/{fabricAgentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Dra_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-02-16-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataReplicationDraResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fabricAgentName"> The fabric agent (Dra) name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="fabricAgentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="fabricAgentName"/> is null. </exception>
        public virtual NullableResponse<DataReplicationDraResource> GetIfExists(string fabricAgentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(fabricAgentName, nameof(fabricAgentName));

            using var scope = _dataReplicationDraDraClientDiagnostics.CreateScope("DataReplicationDraCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _dataReplicationDraDraRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, fabricAgentName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DataReplicationDraResource>(response.GetRawResponse());
                return Response.FromValue(new DataReplicationDraResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<DataReplicationDraResource> IEnumerable<DataReplicationDraResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<DataReplicationDraResource> IAsyncEnumerable<DataReplicationDraResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
