// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmRecoveryServicesDataReplicationModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="RecoveryServicesDataReplication.DataReplicationDraData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Dra model properties. </param>
        /// <returns> A new <see cref="RecoveryServicesDataReplication.DataReplicationDraData"/> instance for mocking. </returns>
        public static DataReplicationDraData DataReplicationDraData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataReplicationDraProperties properties = null)
        {
            return new DataReplicationDraData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationDraProperties"/>. </summary>
        /// <param name="correlationId"> Gets or sets the Dra correlation Id. </param>
        /// <param name="machineId"> Gets or sets the machine Id where Dra is running. </param>
        /// <param name="machineName"> Gets or sets the machine name where Dra is running. </param>
        /// <param name="authenticationIdentity"> Identity model. </param>
        /// <param name="resourceAccessIdentity"> Identity model. </param>
        /// <param name="isResponsive"> Gets or sets a value indicating whether Dra is responsive. </param>
        /// <param name="lastHeartbeatOn"> Gets or sets the time when last heartbeat was sent by the Dra. </param>
        /// <param name="versionNumber"> Gets or sets the Dra version. </param>
        /// <param name="provisioningState"> Gets or sets the provisioning state of the Dra. </param>
        /// <param name="healthErrors"> Gets or sets the list of health errors. </param>
        /// <param name="customProperties">
        /// Dra model custom properties.
        /// Please note <see cref="DraModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="GeneralDraModelCustomProperties"/> and <see cref="VMwareDraModelCustomProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataReplicationDraProperties"/> instance for mocking. </returns>
        public static DataReplicationDraProperties DataReplicationDraProperties(string correlationId = null, string machineId = null, string machineName = null, DataReplicationIdentity authenticationIdentity = null, DataReplicationIdentity resourceAccessIdentity = null, bool? isResponsive = null, DateTimeOffset? lastHeartbeatOn = null, string versionNumber = null, DataReplicationProvisioningState? provisioningState = null, IEnumerable<DataReplicationHealthErrorInfo> healthErrors = null, DraModelCustomProperties customProperties = null)
        {
            healthErrors ??= new List<DataReplicationHealthErrorInfo>();

            return new DataReplicationDraProperties(
                correlationId,
                machineId,
                machineName,
                authenticationIdentity,
                resourceAccessIdentity,
                isResponsive,
                lastHeartbeatOn,
                versionNumber,
                provisioningState,
                healthErrors?.ToList(),
                customProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationHealthErrorInfo"/>. </summary>
        /// <param name="affectedResourceType"> Gets or sets the type of affected resource type. </param>
        /// <param name="affectedResourceCorrelationIds">
        /// Gets or sets the list of affected resource correlation Ids. This can be used to
        /// uniquely identify the count of items affected by a specific category and severity
        /// as well as count of item affected by an specific issue.
        /// </param>
        /// <param name="childErrors"> Gets or sets a list of child health errors associated with this error. </param>
        /// <param name="code"> Gets or sets the error code. </param>
        /// <param name="healthCategory"> Gets or sets the health category. </param>
        /// <param name="category"> Gets or sets the error category. </param>
        /// <param name="severity"> Gets or sets the error severity. </param>
        /// <param name="source"> Gets or sets the error source. </param>
        /// <param name="createdOn"> Gets or sets the error creation time. </param>
        /// <param name="isCustomerResolvable"> Gets or sets a value indicating whether the error is customer resolvable. </param>
        /// <param name="summary"> Gets or sets the error summary. </param>
        /// <param name="message"> Gets or sets the error message. </param>
        /// <param name="causes"> Gets or sets possible causes of the error. </param>
        /// <param name="recommendation"> Gets or sets recommended action to resolve the error. </param>
        /// <returns> A new <see cref="Models.DataReplicationHealthErrorInfo"/> instance for mocking. </returns>
        public static DataReplicationHealthErrorInfo DataReplicationHealthErrorInfo(string affectedResourceType = null, IEnumerable<string> affectedResourceCorrelationIds = null, IEnumerable<DataReplicationInnerHealthErrorInfo> childErrors = null, string code = null, string healthCategory = null, string category = null, string severity = null, string source = null, DateTimeOffset? createdOn = null, bool? isCustomerResolvable = null, string summary = null, string message = null, string causes = null, string recommendation = null)
        {
            affectedResourceCorrelationIds ??= new List<string>();
            childErrors ??= new List<DataReplicationInnerHealthErrorInfo>();

            return new DataReplicationHealthErrorInfo(
                affectedResourceType,
                affectedResourceCorrelationIds?.ToList(),
                childErrors?.ToList(),
                code,
                healthCategory,
                category,
                severity,
                source,
                createdOn,
                isCustomerResolvable,
                summary,
                message,
                causes,
                recommendation,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationInnerHealthErrorInfo"/>. </summary>
        /// <param name="code"> Gets or sets the error code. </param>
        /// <param name="healthCategory"> Gets or sets the health category. </param>
        /// <param name="category"> Gets or sets the error category. </param>
        /// <param name="severity"> Gets or sets the error severity. </param>
        /// <param name="source"> Gets or sets the error source. </param>
        /// <param name="createdOn"> Gets or sets the error creation time. </param>
        /// <param name="isCustomerResolvable"> Gets or sets a value indicating whether the error is customer resolvable. </param>
        /// <param name="summary"> Gets or sets the error summary. </param>
        /// <param name="message"> Gets or sets the error message. </param>
        /// <param name="causes"> Gets or sets possible causes of the error. </param>
        /// <param name="recommendation"> Gets or sets recommended action to resolve the error. </param>
        /// <returns> A new <see cref="Models.DataReplicationInnerHealthErrorInfo"/> instance for mocking. </returns>
        public static DataReplicationInnerHealthErrorInfo DataReplicationInnerHealthErrorInfo(string code = null, string healthCategory = null, string category = null, string severity = null, string source = null, DateTimeOffset? createdOn = null, bool? isCustomerResolvable = null, string summary = null, string message = null, string causes = null, string recommendation = null)
        {
            return new DataReplicationInnerHealthErrorInfo(
                code,
                healthCategory,
                category,
                severity,
                source,
                createdOn,
                isCustomerResolvable,
                summary,
                message,
                causes,
                recommendation,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesDataReplication.DataReplicationEmailConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Email configuration model properties. </param>
        /// <returns> A new <see cref="RecoveryServicesDataReplication.DataReplicationEmailConfigurationData"/> instance for mocking. </returns>
        public static DataReplicationEmailConfigurationData DataReplicationEmailConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataReplicationEmailConfigurationProperties properties = null)
        {
            return new DataReplicationEmailConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesDataReplication.DataReplicationEventData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Event model properties. </param>
        /// <returns> A new <see cref="RecoveryServicesDataReplication.DataReplicationEventData"/> instance for mocking. </returns>
        public static DataReplicationEventData DataReplicationEventData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataReplicationEventProperties properties = null)
        {
            return new DataReplicationEventData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationEventProperties"/>. </summary>
        /// <param name="resourceType"> Gets or sets the resource type. </param>
        /// <param name="resourceName"> Gets or sets the resource name. </param>
        /// <param name="eventType"> Gets or sets the event type. </param>
        /// <param name="eventName"> Gets or sets the event name. </param>
        /// <param name="occurredOn"> Gets or sets the time at which the event occurred at source. </param>
        /// <param name="severity"> Gets or sets the event severity. </param>
        /// <param name="description"> Gets or sets the event description. </param>
        /// <param name="correlationId"> Gets or sets the event correlation Id. </param>
        /// <param name="healthErrors"> Gets or sets the errors associated with this event. </param>
        /// <param name="customProperties">
        /// Event model custom properties.
        /// Please note <see cref="EventModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.HyperVToAzStackHciEventModelCustomProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataReplicationEventProperties"/> instance for mocking. </returns>
        public static DataReplicationEventProperties DataReplicationEventProperties(ResourceType? resourceType = null, string resourceName = null, string eventType = null, string eventName = null, DateTimeOffset? occurredOn = null, string severity = null, string description = null, string correlationId = null, IEnumerable<DataReplicationHealthErrorInfo> healthErrors = null, EventModelCustomProperties customProperties = null)
        {
            healthErrors ??= new List<DataReplicationHealthErrorInfo>();

            return new DataReplicationEventProperties(
                resourceType,
                resourceName,
                eventType,
                eventName,
                occurredOn,
                severity,
                description,
                correlationId,
                healthErrors?.ToList(),
                customProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesDataReplication.DataReplicationFabricData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Fabric model properties. </param>
        /// <returns> A new <see cref="RecoveryServicesDataReplication.DataReplicationFabricData"/> instance for mocking. </returns>
        public static DataReplicationFabricData DataReplicationFabricData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DataReplicationFabricProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DataReplicationFabricData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationFabricProperties"/>. </summary>
        /// <param name="provisioningState"> Gets or sets the provisioning state of the fabric. </param>
        /// <param name="serviceEndpoint"> Gets or sets the service endpoint. </param>
        /// <param name="serviceResourceId"> Gets or sets the service resource Id. </param>
        /// <param name="health"> Gets or sets the fabric health. </param>
        /// <param name="healthErrors"> Gets or sets the list of health errors. </param>
        /// <param name="customProperties">
        /// Fabric model custom properties.
        /// Please note <see cref="FabricModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AzStackHciFabricModelCustomProperties"/>, <see cref="GeneralFabricModelCustomProperties"/>, <see cref="Models.HyperVMigrateFabricModelCustomProperties"/> and <see cref="VMwareMigrateFabricModelCustomProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataReplicationFabricProperties"/> instance for mocking. </returns>
        public static DataReplicationFabricProperties DataReplicationFabricProperties(DataReplicationProvisioningState? provisioningState = null, string serviceEndpoint = null, ResourceIdentifier serviceResourceId = null, DataReplicationHealthStatus? health = null, IEnumerable<DataReplicationHealthErrorInfo> healthErrors = null, FabricModelCustomProperties customProperties = null)
        {
            healthErrors ??= new List<DataReplicationHealthErrorInfo>();

            return new DataReplicationFabricProperties(
                provisioningState,
                serviceEndpoint,
                serviceResourceId,
                health,
                healthErrors?.ToList(),
                customProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationFabricPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> Gets or sets the resource tags. </param>
        /// <param name="properties"> Fabric model properties. </param>
        /// <returns> A new <see cref="Models.DataReplicationFabricPatch"/> instance for mocking. </returns>
        public static DataReplicationFabricPatch DataReplicationFabricPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, DataReplicationFabricProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DataReplicationFabricPatch(
                id,
                name,
                resourceType,
                systemData,
                tags,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesDataReplication.DataReplicationPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Policy model properties. </param>
        /// <returns> A new <see cref="RecoveryServicesDataReplication.DataReplicationPolicyData"/> instance for mocking. </returns>
        public static DataReplicationPolicyData DataReplicationPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataReplicationPolicyProperties properties = null)
        {
            return new DataReplicationPolicyData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationPolicyProperties"/>. </summary>
        /// <param name="provisioningState"> Gets or sets the provisioning state of the policy. </param>
        /// <param name="customProperties">
        /// Policy model custom properties.
        /// Please note <see cref="PolicyModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="HyperVToAzStackHciPolicyModelCustomProperties"/>, <see cref="GeneralPolicyModelCustomProperties"/> and <see cref="VMwareToAzStackHciPolicyModelCustomProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataReplicationPolicyProperties"/> instance for mocking. </returns>
        public static DataReplicationPolicyProperties DataReplicationPolicyProperties(DataReplicationProvisioningState? provisioningState = null, PolicyModelCustomProperties customProperties = null)
        {
            return new DataReplicationPolicyProperties(provisioningState, customProperties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesDataReplication.DataReplicationProtectedItemData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Protected item model properties. </param>
        /// <returns> A new <see cref="RecoveryServicesDataReplication.DataReplicationProtectedItemData"/> instance for mocking. </returns>
        public static DataReplicationProtectedItemData DataReplicationProtectedItemData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataReplicationProtectedItemProperties properties = null)
        {
            return new DataReplicationProtectedItemData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationProtectedItemProperties"/>. </summary>
        /// <param name="policyName"> Gets or sets the policy name. </param>
        /// <param name="replicationExtensionName"> Gets or sets the replication extension name. </param>
        /// <param name="correlationId"> Gets or sets the protected item correlation Id. </param>
        /// <param name="provisioningState"> Gets or sets the provisioning state of the Dra. </param>
        /// <param name="protectionState"> Gets or sets the protection state. </param>
        /// <param name="protectionStateDescription"> Gets or sets the protection state description. </param>
        /// <param name="testFailoverState"> Gets or sets the test failover state. </param>
        /// <param name="testFailoverStateDescription"> Gets or sets the Test failover state description. </param>
        /// <param name="resynchronizationState"> Gets or sets the resynchronization state. </param>
        /// <param name="fabricObjectId"> Gets or sets the fabric object Id. </param>
        /// <param name="fabricObjectName"> Gets or sets the fabric object name. </param>
        /// <param name="sourceFabricProviderId"> Gets or sets the source fabric provider Id. </param>
        /// <param name="targetFabricProviderId"> Gets or sets the target fabric provider Id. </param>
        /// <param name="fabricId"> Gets or sets the fabric Id. </param>
        /// <param name="targetFabricId"> Gets or sets the target fabric Id. </param>
        /// <param name="draId"> Gets or sets the DRA Id. </param>
        /// <param name="targetDraId"> Gets or sets the target DRA Id. </param>
        /// <param name="isResyncRequired"> Gets or sets a value indicating whether resynchronization is required or not. </param>
        /// <param name="lastSuccessfulPlannedFailoverOn"> Gets or sets the Last successful planned failover time. </param>
        /// <param name="lastSuccessfulUnplannedFailoverOn"> Gets or sets the Last successful unplanned failover time. </param>
        /// <param name="lastSuccessfulTestFailoverOn"> Gets or sets the Last successful test failover time. </param>
        /// <param name="currentJob"> Protected item job properties. </param>
        /// <param name="allowedJobs"> Gets or sets the allowed scenarios on the protected item. </param>
        /// <param name="lastFailedEnableProtectionJob"> Protected item job properties. </param>
        /// <param name="lastFailedPlannedFailoverJob"> Protected item job properties. </param>
        /// <param name="lastTestFailoverJob"> Protected item job properties. </param>
        /// <param name="replicationHealth"> Gets or sets protected item replication health. </param>
        /// <param name="healthErrors"> Gets or sets the list of health errors. </param>
        /// <param name="customProperties">
        /// Protected item model custom properties.
        /// Please note <see cref="ProtectedItemModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.HyperVToAzStackHciProtectedItemModelCustomProperties"/>, <see cref="GeneralProtectedItemModelCustomProperties"/> and <see cref="Models.VMwareToAzStackHciProtectedItemModelCustomProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataReplicationProtectedItemProperties"/> instance for mocking. </returns>
        public static DataReplicationProtectedItemProperties DataReplicationProtectedItemProperties(string policyName = null, string replicationExtensionName = null, string correlationId = null, DataReplicationProvisioningState? provisioningState = null, DataReplicationProtectionState? protectionState = null, string protectionStateDescription = null, DataReplicationTestFailoverState? testFailoverState = null, string testFailoverStateDescription = null, DataReplicationResynchronizationState? resynchronizationState = null, string fabricObjectId = null, string fabricObjectName = null, string sourceFabricProviderId = null, string targetFabricProviderId = null, string fabricId = null, string targetFabricId = null, string draId = null, string targetDraId = null, bool? isResyncRequired = null, DateTimeOffset? lastSuccessfulPlannedFailoverOn = null, DateTimeOffset? lastSuccessfulUnplannedFailoverOn = null, DateTimeOffset? lastSuccessfulTestFailoverOn = null, ProtectedItemJobProperties currentJob = null, IEnumerable<string> allowedJobs = null, ProtectedItemJobProperties lastFailedEnableProtectionJob = null, ProtectedItemJobProperties lastFailedPlannedFailoverJob = null, ProtectedItemJobProperties lastTestFailoverJob = null, DataReplicationHealthStatus? replicationHealth = null, IEnumerable<DataReplicationHealthErrorInfo> healthErrors = null, ProtectedItemModelCustomProperties customProperties = null)
        {
            allowedJobs ??= new List<string>();
            healthErrors ??= new List<DataReplicationHealthErrorInfo>();

            return new DataReplicationProtectedItemProperties(
                policyName,
                replicationExtensionName,
                correlationId,
                provisioningState,
                protectionState,
                protectionStateDescription,
                testFailoverState,
                testFailoverStateDescription,
                resynchronizationState,
                fabricObjectId,
                fabricObjectName,
                sourceFabricProviderId,
                targetFabricProviderId,
                fabricId,
                targetFabricId,
                draId,
                targetDraId,
                isResyncRequired,
                lastSuccessfulPlannedFailoverOn,
                lastSuccessfulUnplannedFailoverOn,
                lastSuccessfulTestFailoverOn,
                currentJob,
                allowedJobs?.ToList(),
                lastFailedEnableProtectionJob,
                lastFailedPlannedFailoverJob,
                lastTestFailoverJob,
                replicationHealth,
                healthErrors?.ToList(),
                customProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProtectedItemJobProperties"/>. </summary>
        /// <param name="scenarioName"> Gets or sets protection scenario name. </param>
        /// <param name="id"> Gets or sets workflow Id. </param>
        /// <param name="name"> Gets or sets workflow name. </param>
        /// <param name="displayName"> Gets or sets the workflow friendly display name. </param>
        /// <param name="state"> Gets or sets workflow state. </param>
        /// <param name="startOn"> Gets or sets start time of the workflow. </param>
        /// <param name="endOn"> Gets or sets end time of the workflow. </param>
        /// <returns> A new <see cref="Models.ProtectedItemJobProperties"/> instance for mocking. </returns>
        public static ProtectedItemJobProperties ProtectedItemJobProperties(string scenarioName = null, string id = null, string name = null, string displayName = null, string state = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null)
        {
            return new ProtectedItemJobProperties(
                scenarioName,
                id,
                name,
                displayName,
                state,
                startOn,
                endOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesDataReplication.DataReplicationRecoveryPointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Recovery point model properties. </param>
        /// <returns> A new <see cref="RecoveryServicesDataReplication.DataReplicationRecoveryPointData"/> instance for mocking. </returns>
        public static DataReplicationRecoveryPointData DataReplicationRecoveryPointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataReplicationRecoveryPointProperties properties = null)
        {
            return new DataReplicationRecoveryPointData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationRecoveryPointProperties"/>. </summary>
        /// <param name="recoveryPointOn"> Gets or sets the recovery point time. </param>
        /// <param name="recoveryPointType"> Gets or sets the recovery point type. </param>
        /// <param name="customProperties">
        /// Recovery point model custom properties.
        /// Please note <see cref="RecoveryPointModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.HyperVToAzStackHciRecoveryPointModelCustomProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataReplicationRecoveryPointProperties"/> instance for mocking. </returns>
        public static DataReplicationRecoveryPointProperties DataReplicationRecoveryPointProperties(DateTimeOffset recoveryPointOn = default, DataReplicationRecoveryPointType recoveryPointType = default, RecoveryPointModelCustomProperties customProperties = null)
        {
            return new DataReplicationRecoveryPointProperties(recoveryPointOn, recoveryPointType, customProperties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesDataReplication.DataReplicationReplicationExtensionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Replication extension model properties. </param>
        /// <returns> A new <see cref="RecoveryServicesDataReplication.DataReplicationReplicationExtensionData"/> instance for mocking. </returns>
        public static DataReplicationReplicationExtensionData DataReplicationReplicationExtensionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataReplicationReplicationExtensionProperties properties = null)
        {
            return new DataReplicationReplicationExtensionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationReplicationExtensionProperties"/>. </summary>
        /// <param name="provisioningState"> Gets or sets the provisioning state of the replication extension. </param>
        /// <param name="customProperties">
        /// Replication extension model custom properties.
        /// Please note <see cref="ReplicationExtensionModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.HyperVToAzStackHciReplicationExtensionModelCustomProperties"/>, <see cref="GeneralReplicationExtensionModelCustomProperties"/> and <see cref="Models.VMwareToAzStackHciReplicationExtensionModelCustomProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataReplicationReplicationExtensionProperties"/> instance for mocking. </returns>
        public static DataReplicationReplicationExtensionProperties DataReplicationReplicationExtensionProperties(DataReplicationProvisioningState? provisioningState = null, ReplicationExtensionModelCustomProperties customProperties = null)
        {
            return new DataReplicationReplicationExtensionProperties(provisioningState, customProperties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Gets or sets a value indicating whether resource name is available or not. </param>
        /// <param name="reason"> Gets or sets the reason for resource name unavailability. </param>
        /// <param name="message"> Gets or sets the message for resource name unavailability. </param>
        /// <returns> A new <see cref="Models.DataReplicationNameAvailabilityResult"/> instance for mocking. </returns>
        public static DataReplicationNameAvailabilityResult DataReplicationNameAvailabilityResult(bool? isNameAvailable = null, string reason = null, string message = null)
        {
            return new DataReplicationNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesDataReplication.DataReplicationVaultData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Vault properties. </param>
        /// <returns> A new <see cref="RecoveryServicesDataReplication.DataReplicationVaultData"/> instance for mocking. </returns>
        public static DataReplicationVaultData DataReplicationVaultData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DataReplicationVaultProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DataReplicationVaultData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationVaultProperties"/>. </summary>
        /// <param name="provisioningState"> Gets or sets the provisioning state of the vault. </param>
        /// <param name="serviceResourceId"> Gets or sets the service resource Id. </param>
        /// <param name="vaultType"> Gets or sets the type of vault. </param>
        /// <returns> A new <see cref="Models.DataReplicationVaultProperties"/> instance for mocking. </returns>
        public static DataReplicationVaultProperties DataReplicationVaultProperties(DataReplicationProvisioningState? provisioningState = null, ResourceIdentifier serviceResourceId = null, DataReplicationReplicationVaultType? vaultType = null)
        {
            return new DataReplicationVaultProperties(provisioningState, serviceResourceId, vaultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationVaultPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> Gets or sets the resource tags. </param>
        /// <param name="properties"> Vault properties. </param>
        /// <returns> A new <see cref="Models.DataReplicationVaultPatch"/> instance for mocking. </returns>
        public static DataReplicationVaultPatch DataReplicationVaultPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, DataReplicationVaultProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DataReplicationVaultPatch(
                id,
                name,
                resourceType,
                systemData,
                tags,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesDataReplication.DataReplicationWorkflowData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Workflow model properties. </param>
        /// <returns> A new <see cref="RecoveryServicesDataReplication.DataReplicationWorkflowData"/> instance for mocking. </returns>
        public static DataReplicationWorkflowData DataReplicationWorkflowData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataReplicationWorkflowProperties properties = null)
        {
            return new DataReplicationWorkflowData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationWorkflowProperties"/>. </summary>
        /// <param name="displayName"> Gets or sets the friendly display name. </param>
        /// <param name="state"> Gets or sets the workflow state. </param>
        /// <param name="startOn"> Gets or sets the start time. </param>
        /// <param name="endOn"> Gets or sets the end time. </param>
        /// <param name="objectId"> Gets or sets the affected object Id. </param>
        /// <param name="objectName"> Gets or sets the affected object name. </param>
        /// <param name="objectInternalId"> Gets or sets the affected object internal Id. </param>
        /// <param name="objectInternalName"> Gets or sets the affected object internal name. </param>
        /// <param name="objectType"> Gets or sets the object type. </param>
        /// <param name="replicationProviderId"> Gets or sets the replication provider. </param>
        /// <param name="sourceFabricProviderId"> Gets or sets the source fabric provider. </param>
        /// <param name="targetFabricProviderId"> Gets or sets the target fabric provider. </param>
        /// <param name="allowedActions"> Gets or sets the list of allowed actions on the workflow. </param>
        /// <param name="activityId"> Gets or sets the workflow activity id. </param>
        /// <param name="tasks"> Gets or sets the list of tasks. </param>
        /// <param name="errors"> Gets or sets the list of errors. </param>
        /// <param name="customProperties">
        /// Workflow model custom properties.
        /// Please note <see cref="Models.WorkflowModelCustomProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.FailoverWorkflowModelCustomProperties"/>, <see cref="Models.TestFailoverCleanupWorkflowModelCustomProperties"/> and <see cref="Models.TestFailoverWorkflowModelCustomProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataReplicationWorkflowProperties"/> instance for mocking. </returns>
        public static DataReplicationWorkflowProperties DataReplicationWorkflowProperties(string displayName = null, DataReplicationWorkflowState? state = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string objectId = null, string objectName = null, string objectInternalId = null, string objectInternalName = null, WorkflowObjectType? objectType = null, string replicationProviderId = null, string sourceFabricProviderId = null, string targetFabricProviderId = null, IEnumerable<string> allowedActions = null, string activityId = null, IEnumerable<DataReplicationTask> tasks = null, IEnumerable<DataReplicationErrorInfo> errors = null, WorkflowModelCustomProperties customProperties = null)
        {
            allowedActions ??= new List<string>();
            tasks ??= new List<DataReplicationTask>();
            errors ??= new List<DataReplicationErrorInfo>();

            return new DataReplicationWorkflowProperties(
                displayName,
                state,
                startOn,
                endOn,
                objectId,
                objectName,
                objectInternalId,
                objectInternalName,
                objectType,
                replicationProviderId,
                sourceFabricProviderId,
                targetFabricProviderId,
                allowedActions?.ToList(),
                activityId,
                tasks?.ToList(),
                errors?.ToList(),
                customProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationTask"/>. </summary>
        /// <param name="taskName"> Gets or sets the task name. </param>
        /// <param name="state"> Gets or sets the task state. </param>
        /// <param name="startOn"> Gets or sets the start time. </param>
        /// <param name="endOn"> Gets or sets the end time. </param>
        /// <param name="customInstanceType"> Task model custom properties. </param>
        /// <param name="childrenWorkflows"> Gets or sets the list of children workflow models. </param>
        /// <returns> A new <see cref="Models.DataReplicationTask"/> instance for mocking. </returns>
        public static DataReplicationTask DataReplicationTask(string taskName = null, DataReplicationTaskState? state = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string customInstanceType = null, IEnumerable<DataReplicationWorkflowData> childrenWorkflows = null)
        {
            childrenWorkflows ??= new List<DataReplicationWorkflowData>();

            return new DataReplicationTask(
                taskName,
                state,
                startOn,
                endOn,
                customInstanceType != null ? new TaskModelCustomProperties(customInstanceType, serializedAdditionalRawData: null) : null,
                childrenWorkflows?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataReplicationErrorInfo"/>. </summary>
        /// <param name="code"> Gets or sets the error code. </param>
        /// <param name="errorModelType"> Gets or sets the error type. </param>
        /// <param name="severity"> Gets or sets the error severity. </param>
        /// <param name="createdOn"> Gets or sets the creation time of error. </param>
        /// <param name="message"> Gets or sets the error message. </param>
        /// <param name="causes"> Gets or sets the possible causes of error. </param>
        /// <param name="recommendation"> Gets or sets the recommended action to resolve error. </param>
        /// <returns> A new <see cref="Models.DataReplicationErrorInfo"/> instance for mocking. </returns>
        public static DataReplicationErrorInfo DataReplicationErrorInfo(string code = null, string errorModelType = null, string severity = null, DateTimeOffset? createdOn = null, string message = null, string causes = null, string recommendation = null)
        {
            return new DataReplicationErrorInfo(
                code,
                errorModelType,
                severity,
                createdOn,
                message,
                causes,
                recommendation,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WorkflowModelCustomProperties"/>. </summary>
        /// <param name="instanceType"> Gets or sets the instance type. </param>
        /// <param name="affectedObjectDetails"> Gets or sets any custom properties of the affected object. </param>
        /// <returns> A new <see cref="Models.WorkflowModelCustomProperties"/> instance for mocking. </returns>
        public static WorkflowModelCustomProperties WorkflowModelCustomProperties(string instanceType = null, IReadOnlyDictionary<string, string> affectedObjectDetails = null)
        {
            affectedObjectDetails ??= new Dictionary<string, string>();

            return new UnknownWorkflowModelCustomProperties(instanceType, affectedObjectDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzStackHciFabricModelCustomProperties"/>. </summary>
        /// <param name="azStackHciSiteId"> Gets or sets the ARM Id of the AzStackHCI site. </param>
        /// <param name="applianceName"> Gets or sets the Appliance name. </param>
        /// <param name="cluster"> AzStackHCI cluster properties. </param>
        /// <param name="fabricResourceId"> Gets or sets the fabric resource Id. </param>
        /// <param name="fabricContainerId"> Gets or sets the fabric container Id. </param>
        /// <param name="migrationSolutionId"> Gets or sets the Migration solution ARM Id. </param>
        /// <param name="migrationHubUri"> Gets or sets the migration hub Uri. </param>
        /// <returns> A new <see cref="Models.AzStackHciFabricModelCustomProperties"/> instance for mocking. </returns>
        public static AzStackHciFabricModelCustomProperties AzStackHciFabricModelCustomProperties(ResourceIdentifier azStackHciSiteId = null, IEnumerable<string> applianceName = null, AzStackHciClusterProperties cluster = null, ResourceIdentifier fabricResourceId = null, string fabricContainerId = null, ResourceIdentifier migrationSolutionId = null, Uri migrationHubUri = null)
        {
            applianceName ??= new List<string>();

            return new AzStackHciFabricModelCustomProperties(
                "AzStackHCI",
                serializedAdditionalRawData: null,
                azStackHciSiteId,
                applianceName?.ToList(),
                cluster,
                fabricResourceId,
                fabricContainerId,
                migrationSolutionId,
                migrationHubUri);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FailoverProtectedItemProperties"/>. </summary>
        /// <param name="protectedItemName"> Gets or sets the protected item name. </param>
        /// <param name="vmName"> Gets or sets the VM name. </param>
        /// <param name="testVmName"> Gets or sets the test VM name. </param>
        /// <param name="recoveryPointId"> Gets or sets the recovery point Id. </param>
        /// <param name="recoveryPointOn"> Gets or sets the recovery point time. </param>
        /// <param name="networkName"> Gets or sets the network name. </param>
        /// <param name="subnet"> Gets or sets the network subnet. </param>
        /// <returns> A new <see cref="Models.FailoverProtectedItemProperties"/> instance for mocking. </returns>
        public static FailoverProtectedItemProperties FailoverProtectedItemProperties(string protectedItemName = null, string vmName = null, string testVmName = null, string recoveryPointId = null, DateTimeOffset? recoveryPointOn = null, string networkName = null, string subnet = null)
        {
            return new FailoverProtectedItemProperties(
                protectedItemName,
                vmName,
                testVmName,
                recoveryPointId,
                recoveryPointOn,
                networkName,
                subnet,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FailoverWorkflowModelCustomProperties"/>. </summary>
        /// <param name="affectedObjectDetails"> Gets or sets any custom properties of the affected object. </param>
        /// <param name="protectedItemDetails"> Gets or sets the failed over protected item details. </param>
        /// <returns> A new <see cref="Models.FailoverWorkflowModelCustomProperties"/> instance for mocking. </returns>
        public static FailoverWorkflowModelCustomProperties FailoverWorkflowModelCustomProperties(IReadOnlyDictionary<string, string> affectedObjectDetails = null, IEnumerable<FailoverProtectedItemProperties> protectedItemDetails = null)
        {
            affectedObjectDetails ??= new Dictionary<string, string>();
            protectedItemDetails ??= new List<FailoverProtectedItemProperties>();

            return new FailoverWorkflowModelCustomProperties("FailoverWorkflowDetails", affectedObjectDetails, serializedAdditionalRawData: null, protectedItemDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVMigrateFabricModelCustomProperties"/>. </summary>
        /// <param name="hyperVSiteId"> Gets or sets the ARM Id of the HyperV site. </param>
        /// <param name="fabricResourceId"> Gets or sets the fabric resource Id. </param>
        /// <param name="fabricContainerId"> Gets or sets the fabric container Id. </param>
        /// <param name="migrationSolutionId"> Gets or sets the migration solution ARM Id. </param>
        /// <param name="migrationHubUri"> Gets or sets the migration hub Uri. </param>
        /// <returns> A new <see cref="Models.HyperVMigrateFabricModelCustomProperties"/> instance for mocking. </returns>
        public static HyperVMigrateFabricModelCustomProperties HyperVMigrateFabricModelCustomProperties(ResourceIdentifier hyperVSiteId = null, ResourceIdentifier fabricResourceId = null, string fabricContainerId = null, ResourceIdentifier migrationSolutionId = null, Uri migrationHubUri = null)
        {
            return new HyperVMigrateFabricModelCustomProperties(
                "HyperVMigrate",
                serializedAdditionalRawData: null,
                hyperVSiteId,
                fabricResourceId,
                fabricContainerId,
                migrationSolutionId,
                migrationHubUri);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVToAzStackHciEventModelCustomProperties"/>. </summary>
        /// <param name="eventSourceFriendlyName"> Gets or sets the friendly name of the source which has raised this health event. </param>
        /// <param name="protectedItemFriendlyName"> Gets or sets the protected item friendly name. </param>
        /// <param name="sourceApplianceName"> Gets or sets the source appliance name. </param>
        /// <param name="targetApplianceName"> Gets or sets the source target name. </param>
        /// <param name="serverType"> Gets or sets the server type. </param>
        /// <returns> A new <see cref="Models.HyperVToAzStackHciEventModelCustomProperties"/> instance for mocking. </returns>
        public static HyperVToAzStackHciEventModelCustomProperties HyperVToAzStackHciEventModelCustomProperties(string eventSourceFriendlyName = null, string protectedItemFriendlyName = null, string sourceApplianceName = null, string targetApplianceName = null, string serverType = null)
        {
            return new HyperVToAzStackHciEventModelCustomProperties(
                "HyperVToAzStackHCI",
                serializedAdditionalRawData: null,
                eventSourceFriendlyName,
                protectedItemFriendlyName,
                sourceApplianceName,
                targetApplianceName,
                serverType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVToAzStackHciNicInput"/>. </summary>
        /// <param name="nicId"> Gets or sets the NIC Id. </param>
        /// <param name="networkName"> Gets or sets the network name. </param>
        /// <param name="targetNetworkId"> Gets or sets the target network Id within AzStackHCI Cluster. </param>
        /// <param name="testNetworkId"> Gets or sets the target test network Id within AzStackHCI Cluster. </param>
        /// <param name="selectionTypeForFailover"> Gets or sets the selection type of the NIC. </param>
        /// <returns> A new <see cref="Models.HyperVToAzStackHciNicInput"/> instance for mocking. </returns>
        public static HyperVToAzStackHciNicInput HyperVToAzStackHciNicInput(string nicId = null, string networkName = null, string targetNetworkId = null, string testNetworkId = null, VmNicSelection selectionTypeForFailover = default)
        {
            return new HyperVToAzStackHciNicInput(
                nicId,
                networkName,
                targetNetworkId,
                testNetworkId,
                selectionTypeForFailover,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVToAzStackHciProtectedDiskProperties"/>. </summary>
        /// <param name="storageContainerId"> Gets or sets the ARM Id of the storage container. </param>
        /// <param name="storageContainerLocalPath"> Gets or sets the local path of the storage container. </param>
        /// <param name="sourceDiskId"> Gets or sets the source disk Id. </param>
        /// <param name="sourceDiskName"> Gets or sets the source disk Name. </param>
        /// <param name="seedDiskName"> Gets or sets the seed disk name. </param>
        /// <param name="testMigrateDiskName"> Gets or sets the test failover clone disk. </param>
        /// <param name="migrateDiskName"> Gets or sets the failover clone disk. </param>
        /// <param name="isOSDisk"> Gets or sets a value indicating whether the disk is the OS disk. </param>
        /// <param name="capacityInBytes"> Gets or sets the disk capacity in bytes. </param>
        /// <param name="isDynamic">
        /// Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard
        /// disk.
        /// </param>
        /// <param name="diskType"> Gets or sets the disk type. </param>
        /// <returns> A new <see cref="Models.HyperVToAzStackHciProtectedDiskProperties"/> instance for mocking. </returns>
        public static HyperVToAzStackHciProtectedDiskProperties HyperVToAzStackHciProtectedDiskProperties(ResourceIdentifier storageContainerId = null, string storageContainerLocalPath = null, string sourceDiskId = null, string sourceDiskName = null, string seedDiskName = null, string testMigrateDiskName = null, string migrateDiskName = null, bool? isOSDisk = null, long? capacityInBytes = null, bool? isDynamic = null, string diskType = null)
        {
            return new HyperVToAzStackHciProtectedDiskProperties(
                storageContainerId,
                storageContainerLocalPath,
                sourceDiskId,
                sourceDiskName,
                seedDiskName,
                testMigrateDiskName,
                migrateDiskName,
                isOSDisk,
                capacityInBytes,
                isDynamic,
                diskType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVToAzStackHciProtectedItemModelCustomProperties"/>. </summary>
        /// <param name="activeLocation"> Gets or sets the location of the protected item. </param>
        /// <param name="targetHciClusterId"> Gets or sets the Target HCI Cluster ARM Id. </param>
        /// <param name="targetArcClusterCustomLocationId"> Gets or sets the Target Arc Cluster Custom Location ARM Id. </param>
        /// <param name="targetAzStackHciClusterName"> Gets or sets the Target AzStackHCI cluster name. </param>
        /// <param name="fabricDiscoveryMachineId"> Gets or sets the ARM Id of the discovered machine. </param>
        /// <param name="disksToInclude"> Gets or sets the list of disks to replicate. </param>
        /// <param name="nicsToInclude"> Gets or sets the list of VM NIC to replicate. </param>
        /// <param name="sourceVmName"> Gets or sets the source VM display name. </param>
        /// <param name="sourceCpuCores"> Gets or sets the source VM CPU cores. </param>
        /// <param name="sourceMemoryInMegaBytes"> Gets or sets the source VM ram memory size in megabytes. </param>
        /// <param name="targetVmName"> Gets or sets the target VM display name. </param>
        /// <param name="targetResourceGroupId"> Gets or sets the target resource group ARM Id. </param>
        /// <param name="storageContainerId"> Gets or sets the target storage container ARM Id. </param>
        /// <param name="hyperVGeneration"> Gets or sets the hypervisor generation of the virtual machine. </param>
        /// <param name="targetNetworkId"> Gets or sets the target network Id within AzStackHCI Cluster. </param>
        /// <param name="testNetworkId"> Gets or sets the target test network Id within AzStackHCI Cluster. </param>
        /// <param name="targetCpuCores"> Gets or sets the target CPU cores. </param>
        /// <param name="isDynamicRam"> Gets or sets a value indicating whether memory is dynamical. </param>
        /// <param name="dynamicMemoryConfig"> Protected item dynamic memory config. </param>
        /// <param name="targetMemoryInMegaBytes"> Gets or sets the target memory in mega-bytes. </param>
        /// <param name="runAsAccountId"> Gets or sets the Run As account Id. </param>
        /// <param name="sourceDraName"> Gets or sets the source DRA name. </param>
        /// <param name="targetDraName"> Gets or sets the target DRA name. </param>
        /// <param name="sourceApplianceName"> Gets or sets the source appliance name. </param>
        /// <param name="targetApplianceName"> Gets or sets the target appliance name. </param>
        /// <param name="osType"> Gets or sets the type of the OS. </param>
        /// <param name="osName"> Gets or sets the name of the OS. </param>
        /// <param name="firmwareType"> Gets or sets the firmware type. </param>
        /// <param name="targetLocation"> Gets or sets the target location. </param>
        /// <param name="customLocationRegion"> Gets or sets the location of Azure Arc HCI custom location resource. </param>
        /// <param name="failoverRecoveryPointId"> Gets or sets the recovery point Id to which the VM was failed over. </param>
        /// <param name="lastRecoveryPointReceived"> Gets or sets the last recovery point received time. </param>
        /// <param name="lastRecoveryPointId"> Gets or sets the last recovery point Id. </param>
        /// <param name="initialReplicationProgressPercentage">
        /// Gets or sets the initial replication progress percentage. This is calculated based on
        /// total bytes processed for all disks in the source VM.
        /// </param>
        /// <param name="resyncProgressPercentage">
        /// Gets or sets the resync progress percentage. This is calculated based on total bytes
        /// processed for all disks in the source VM.
        /// </param>
        /// <param name="protectedDisks"> Gets or sets the list of protected disks. </param>
        /// <param name="protectedNics"> Gets or sets the VM NIC details. </param>
        /// <param name="targetVmBiosId"> Gets or sets the BIOS Id of the target AzStackHCI VM. </param>
        /// <param name="lastReplicationUpdateOn"> Gets or sets the latest timestamp that replication status is updated. </param>
        /// <returns> A new <see cref="Models.HyperVToAzStackHciProtectedItemModelCustomProperties"/> instance for mocking. </returns>
        public static HyperVToAzStackHciProtectedItemModelCustomProperties HyperVToAzStackHciProtectedItemModelCustomProperties(ProtectedItemActiveLocation? activeLocation = null, ResourceIdentifier targetHciClusterId = null, ResourceIdentifier targetArcClusterCustomLocationId = null, string targetAzStackHciClusterName = null, ResourceIdentifier fabricDiscoveryMachineId = null, IEnumerable<HyperVToAzStackHciDiskInput> disksToInclude = null, IEnumerable<HyperVToAzStackHciNicInput> nicsToInclude = null, string sourceVmName = null, int? sourceCpuCores = null, double? sourceMemoryInMegaBytes = null, string targetVmName = null, ResourceIdentifier targetResourceGroupId = null, ResourceIdentifier storageContainerId = null, string hyperVGeneration = null, string targetNetworkId = null, string testNetworkId = null, int? targetCpuCores = null, bool? isDynamicRam = null, ProtectedItemDynamicMemoryConfig dynamicMemoryConfig = null, int? targetMemoryInMegaBytes = null, string runAsAccountId = null, string sourceDraName = null, string targetDraName = null, string sourceApplianceName = null, string targetApplianceName = null, string osType = null, string osName = null, string firmwareType = null, string targetLocation = null, string customLocationRegion = null, string failoverRecoveryPointId = null, DateTimeOffset? lastRecoveryPointReceived = null, string lastRecoveryPointId = null, int? initialReplicationProgressPercentage = null, int? resyncProgressPercentage = null, IEnumerable<HyperVToAzStackHciProtectedDiskProperties> protectedDisks = null, IEnumerable<HyperVToAzStackHciProtectedNicProperties> protectedNics = null, string targetVmBiosId = null, DateTimeOffset? lastReplicationUpdateOn = null)
        {
            disksToInclude ??= new List<HyperVToAzStackHciDiskInput>();
            nicsToInclude ??= new List<HyperVToAzStackHciNicInput>();
            protectedDisks ??= new List<HyperVToAzStackHciProtectedDiskProperties>();
            protectedNics ??= new List<HyperVToAzStackHciProtectedNicProperties>();

            return new HyperVToAzStackHciProtectedItemModelCustomProperties(
                "HyperVToAzStackHCI",
                serializedAdditionalRawData: null,
                activeLocation,
                targetHciClusterId,
                targetArcClusterCustomLocationId,
                targetAzStackHciClusterName,
                fabricDiscoveryMachineId,
                disksToInclude?.ToList(),
                nicsToInclude?.ToList(),
                sourceVmName,
                sourceCpuCores,
                sourceMemoryInMegaBytes,
                targetVmName,
                targetResourceGroupId,
                storageContainerId,
                hyperVGeneration,
                targetNetworkId,
                testNetworkId,
                targetCpuCores,
                isDynamicRam,
                dynamicMemoryConfig,
                targetMemoryInMegaBytes,
                runAsAccountId,
                sourceDraName,
                targetDraName,
                sourceApplianceName,
                targetApplianceName,
                osType,
                osName,
                firmwareType,
                targetLocation,
                customLocationRegion,
                failoverRecoveryPointId,
                lastRecoveryPointReceived,
                lastRecoveryPointId,
                initialReplicationProgressPercentage,
                resyncProgressPercentage,
                protectedDisks?.ToList(),
                protectedNics?.ToList(),
                targetVmBiosId,
                lastReplicationUpdateOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVToAzStackHciProtectedNicProperties"/>. </summary>
        /// <param name="nicId"> Gets or sets the NIC Id. </param>
        /// <param name="macAddress"> Gets or sets the NIC mac address. </param>
        /// <param name="networkName"> Gets or sets the network name. </param>
        /// <param name="targetNetworkId"> Gets or sets the target network Id within AzStackHCI Cluster. </param>
        /// <param name="testNetworkId"> Gets or sets the target test network Id within AzStackHCI Cluster. </param>
        /// <param name="selectionTypeForFailover"> Gets or sets the selection type of the NIC. </param>
        /// <returns> A new <see cref="Models.HyperVToAzStackHciProtectedNicProperties"/> instance for mocking. </returns>
        public static HyperVToAzStackHciProtectedNicProperties HyperVToAzStackHciProtectedNicProperties(string nicId = null, string macAddress = null, string networkName = null, string targetNetworkId = null, string testNetworkId = null, VmNicSelection? selectionTypeForFailover = null)
        {
            return new HyperVToAzStackHciProtectedNicProperties(
                nicId,
                macAddress,
                networkName,
                targetNetworkId,
                testNetworkId,
                selectionTypeForFailover,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVToAzStackHciRecoveryPointModelCustomProperties"/>. </summary>
        /// <param name="diskIds"> Gets or sets the list of the disk Ids. </param>
        /// <returns> A new <see cref="Models.HyperVToAzStackHciRecoveryPointModelCustomProperties"/> instance for mocking. </returns>
        public static HyperVToAzStackHciRecoveryPointModelCustomProperties HyperVToAzStackHciRecoveryPointModelCustomProperties(IEnumerable<string> diskIds = null)
        {
            diskIds ??= new List<string>();

            return new HyperVToAzStackHciRecoveryPointModelCustomProperties("HyperVToAzStackHCI", serializedAdditionalRawData: null, diskIds?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVToAzStackHciReplicationExtensionModelCustomProperties"/>. </summary>
        /// <param name="hyperVFabricArmId"> Gets or sets the ARM Id of the source HyperV fabric. </param>
        /// <param name="hyperVSiteId"> Gets or sets the ARM Id of the HyperV site. </param>
        /// <param name="azStackHciFabricArmId"> Gets or sets the ARM Id of the target AzStackHCI fabric. </param>
        /// <param name="azStackHciSiteId"> Gets or sets the ARM Id of the AzStackHCI site. </param>
        /// <param name="storageAccountId"> Gets or sets the storage account Id. </param>
        /// <param name="storageAccountSasSecretName"> Gets or sets the Sas Secret of storage account. </param>
        /// <param name="asrServiceUri"> Gets or sets the Uri of ASR. </param>
        /// <param name="rcmServiceUri"> Gets or sets the Uri of Rcm. </param>
        /// <param name="gatewayServiceUri"> Gets or sets the Uri of Gateway. </param>
        /// <param name="sourceGatewayServiceId"> Gets or sets the gateway service Id of source. </param>
        /// <param name="targetGatewayServiceId"> Gets or sets the gateway service Id of target. </param>
        /// <param name="sourceStorageContainerName"> Gets or sets the source storage container name. </param>
        /// <param name="targetStorageContainerName"> Gets or sets the target storage container name. </param>
        /// <param name="resourceLocation"> Gets or sets the resource location. </param>
        /// <param name="subscriptionId"> Gets or sets the subscription. </param>
        /// <param name="resourceGroup"> Gets or sets the resource group. </param>
        /// <returns> A new <see cref="Models.HyperVToAzStackHciReplicationExtensionModelCustomProperties"/> instance for mocking. </returns>
        public static HyperVToAzStackHciReplicationExtensionModelCustomProperties HyperVToAzStackHciReplicationExtensionModelCustomProperties(ResourceIdentifier hyperVFabricArmId = null, ResourceIdentifier hyperVSiteId = null, ResourceIdentifier azStackHciFabricArmId = null, ResourceIdentifier azStackHciSiteId = null, string storageAccountId = null, string storageAccountSasSecretName = null, Uri asrServiceUri = null, Uri rcmServiceUri = null, Uri gatewayServiceUri = null, string sourceGatewayServiceId = null, string targetGatewayServiceId = null, string sourceStorageContainerName = null, string targetStorageContainerName = null, string resourceLocation = null, string subscriptionId = null, string resourceGroup = null)
        {
            return new HyperVToAzStackHciReplicationExtensionModelCustomProperties(
                "HyperVToAzStackHCI",
                serializedAdditionalRawData: null,
                hyperVFabricArmId,
                hyperVSiteId,
                azStackHciFabricArmId,
                azStackHciSiteId,
                storageAccountId,
                storageAccountSasSecretName,
                asrServiceUri,
                rcmServiceUri,
                gatewayServiceUri,
                sourceGatewayServiceId,
                targetGatewayServiceId,
                sourceStorageContainerName,
                targetStorageContainerName,
                resourceLocation,
                subscriptionId,
                resourceGroup);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TestFailoverCleanupWorkflowModelCustomProperties"/>. </summary>
        /// <param name="affectedObjectDetails"> Gets or sets any custom properties of the affected object. </param>
        /// <param name="comments"> Gets or sets the test failover cleanup comments. </param>
        /// <returns> A new <see cref="Models.TestFailoverCleanupWorkflowModelCustomProperties"/> instance for mocking. </returns>
        public static TestFailoverCleanupWorkflowModelCustomProperties TestFailoverCleanupWorkflowModelCustomProperties(IReadOnlyDictionary<string, string> affectedObjectDetails = null, string comments = null)
        {
            affectedObjectDetails ??= new Dictionary<string, string>();

            return new TestFailoverCleanupWorkflowModelCustomProperties("TestFailoverCleanupWorkflowDetails", affectedObjectDetails, serializedAdditionalRawData: null, comments);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TestFailoverWorkflowModelCustomProperties"/>. </summary>
        /// <param name="affectedObjectDetails"> Gets or sets any custom properties of the affected object. </param>
        /// <param name="protectedItemDetails"> Gets or sets the test VM details. </param>
        /// <returns> A new <see cref="Models.TestFailoverWorkflowModelCustomProperties"/> instance for mocking. </returns>
        public static TestFailoverWorkflowModelCustomProperties TestFailoverWorkflowModelCustomProperties(IReadOnlyDictionary<string, string> affectedObjectDetails = null, IEnumerable<FailoverProtectedItemProperties> protectedItemDetails = null)
        {
            affectedObjectDetails ??= new Dictionary<string, string>();
            protectedItemDetails ??= new List<FailoverProtectedItemProperties>();

            return new TestFailoverWorkflowModelCustomProperties("TestFailoverWorkflowDetails", affectedObjectDetails, serializedAdditionalRawData: null, protectedItemDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareToAzStackHciNicInput"/>. </summary>
        /// <param name="nicId"> Gets or sets the NIC Id. </param>
        /// <param name="label"> Gets or sets the NIC label. </param>
        /// <param name="networkName"> Gets or sets the network name. </param>
        /// <param name="targetNetworkId"> Gets or sets the target network Id within AzStackHCI Cluster. </param>
        /// <param name="testNetworkId"> Gets or sets the target test network Id within AzStackHCI Cluster. </param>
        /// <param name="selectionTypeForFailover"> Gets or sets the selection type of the NIC. </param>
        /// <returns> A new <see cref="Models.VMwareToAzStackHciNicInput"/> instance for mocking. </returns>
        public static VMwareToAzStackHciNicInput VMwareToAzStackHciNicInput(string nicId = null, string label = null, string networkName = null, string targetNetworkId = null, string testNetworkId = null, VmNicSelection selectionTypeForFailover = default)
        {
            return new VMwareToAzStackHciNicInput(
                nicId,
                label,
                networkName,
                targetNetworkId,
                testNetworkId,
                selectionTypeForFailover,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareToAzStackHciProtectedDiskProperties"/>. </summary>
        /// <param name="storageContainerId"> Gets or sets the ARM Id of the storage container. </param>
        /// <param name="storageContainerLocalPath"> Gets or sets the local path of the storage container. </param>
        /// <param name="sourceDiskId"> Gets or sets the source disk Id. </param>
        /// <param name="sourceDiskName"> Gets or sets the source disk Name. </param>
        /// <param name="seedDiskName"> Gets or sets the seed disk name. </param>
        /// <param name="testMigrateDiskName"> Gets or sets the test failover clone disk. </param>
        /// <param name="migrateDiskName"> Gets or sets the failover clone disk. </param>
        /// <param name="isOSDisk"> Gets or sets a value indicating whether the disk is the OS disk. </param>
        /// <param name="capacityInBytes"> Gets or sets the disk capacity in bytes. </param>
        /// <param name="isDynamic">
        /// Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard
        /// disk.
        /// </param>
        /// <param name="diskType"> Gets or sets the disk type. </param>
        /// <returns> A new <see cref="Models.VMwareToAzStackHciProtectedDiskProperties"/> instance for mocking. </returns>
        public static VMwareToAzStackHciProtectedDiskProperties VMwareToAzStackHciProtectedDiskProperties(ResourceIdentifier storageContainerId = null, string storageContainerLocalPath = null, string sourceDiskId = null, string sourceDiskName = null, string seedDiskName = null, string testMigrateDiskName = null, string migrateDiskName = null, bool? isOSDisk = null, long? capacityInBytes = null, bool? isDynamic = null, string diskType = null)
        {
            return new VMwareToAzStackHciProtectedDiskProperties(
                storageContainerId,
                storageContainerLocalPath,
                sourceDiskId,
                sourceDiskName,
                seedDiskName,
                testMigrateDiskName,
                migrateDiskName,
                isOSDisk,
                capacityInBytes,
                isDynamic,
                diskType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareToAzStackHciProtectedItemModelCustomProperties"/>. </summary>
        /// <param name="activeLocation"> Gets or sets the location of the protected item. </param>
        /// <param name="targetHciClusterId"> Gets or sets the Target HCI Cluster ARM Id. </param>
        /// <param name="targetArcClusterCustomLocationId"> Gets or sets the Target Arc Cluster Custom Location ARM Id. </param>
        /// <param name="targetAzStackHciClusterName"> Gets or sets the Target AzStackHCI cluster name. </param>
        /// <param name="storageContainerId"> Gets or sets the target storage container ARM Id. </param>
        /// <param name="targetResourceGroupId"> Gets or sets the target resource group ARM Id. </param>
        /// <param name="targetLocation"> Gets or sets the target location. </param>
        /// <param name="customLocationRegion"> Gets or sets the location of Azure Arc HCI custom location resource. </param>
        /// <param name="disksToInclude"> Gets or sets the list of disks to replicate. </param>
        /// <param name="nicsToInclude"> Gets or sets the list of VM NIC to replicate. </param>
        /// <param name="protectedDisks"> Gets or sets the list of protected disks. </param>
        /// <param name="protectedNics"> Gets or sets the VM NIC details. </param>
        /// <param name="targetVmBiosId"> Gets or sets the BIOS Id of the target AzStackHCI VM. </param>
        /// <param name="targetVmName"> Gets or sets the target VM display name. </param>
        /// <param name="hyperVGeneration"> Gets or sets the hypervisor generation of the virtual machine possible values are 1,2. </param>
        /// <param name="targetNetworkId"> Gets or sets the target network Id within AzStackHCI Cluster. </param>
        /// <param name="testNetworkId"> Gets or sets the target test network Id within AzStackHCI Cluster. </param>
        /// <param name="targetCpuCores"> Gets or sets the target CPU cores. </param>
        /// <param name="isDynamicRam"> Gets or sets a value indicating whether memory is dynamical. </param>
        /// <param name="dynamicMemoryConfig"> Protected item dynamic memory config. </param>
        /// <param name="targetMemoryInMegaBytes"> Gets or sets the target memory in mega-bytes. </param>
        /// <param name="osType"> Gets or sets the type of the OS. </param>
        /// <param name="osName"> Gets or sets the name of the OS. </param>
        /// <param name="firmwareType"> Gets or sets the firmware type. </param>
        /// <param name="fabricDiscoveryMachineId"> Gets or sets the ARM Id of the discovered machine. </param>
        /// <param name="sourceVmName"> Gets or sets the source VM display name. </param>
        /// <param name="sourceCpuCores"> Gets or sets the source VM CPU cores. </param>
        /// <param name="sourceMemoryInMegaBytes"> Gets or sets the source VM ram memory size in megabytes. </param>
        /// <param name="runAsAccountId"> Gets or sets the run as account Id. </param>
        /// <param name="sourceDraName"> Gets or sets the source DRA name. </param>
        /// <param name="targetDraName"> Gets or sets the target DRA name. </param>
        /// <param name="sourceApplianceName"> Gets or sets the source appliance name. </param>
        /// <param name="targetApplianceName"> Gets or sets the target appliance name. </param>
        /// <param name="failoverRecoveryPointId"> Gets or sets the recovery point Id to which the VM was failed over. </param>
        /// <param name="lastRecoveryPointReceived"> Gets or sets the last recovery point received time. </param>
        /// <param name="lastRecoveryPointId"> Gets or sets the last recovery point Id. </param>
        /// <param name="initialReplicationProgressPercentage">
        /// Gets or sets the initial replication progress percentage. This is calculated based on
        /// total bytes processed for all disks in the source VM.
        /// </param>
        /// <param name="migrationProgressPercentage"> Gets or sets the migration progress percentage. </param>
        /// <param name="resumeProgressPercentage"> Gets or sets the resume progress percentage. </param>
        /// <param name="resyncProgressPercentage">
        /// Gets or sets the resync progress percentage. This is calculated based on total bytes
        /// processed for all disks in the source VM.
        /// </param>
        /// <param name="resyncRetryCount"> Gets or sets the resync retry count. </param>
        /// <param name="resyncRequired"> Gets or sets a value indicating whether resync is required. </param>
        /// <param name="resyncState"> Gets or sets the resync state. </param>
        /// <param name="performAutoResync"> Gets or sets a value indicating whether auto resync is to be done. </param>
        /// <param name="resumeRetryCount"> Gets or sets the resume retry count. </param>
        /// <param name="lastReplicationUpdateOn"> Gets or sets the latest timestamp that replication status is updated. </param>
        /// <returns> A new <see cref="Models.VMwareToAzStackHciProtectedItemModelCustomProperties"/> instance for mocking. </returns>
        public static VMwareToAzStackHciProtectedItemModelCustomProperties VMwareToAzStackHciProtectedItemModelCustomProperties(ProtectedItemActiveLocation? activeLocation = null, ResourceIdentifier targetHciClusterId = null, ResourceIdentifier targetArcClusterCustomLocationId = null, string targetAzStackHciClusterName = null, ResourceIdentifier storageContainerId = null, ResourceIdentifier targetResourceGroupId = null, string targetLocation = null, string customLocationRegion = null, IEnumerable<VMwareToAzStackHciDiskInput> disksToInclude = null, IEnumerable<VMwareToAzStackHciNicInput> nicsToInclude = null, IEnumerable<VMwareToAzStackHciProtectedDiskProperties> protectedDisks = null, IEnumerable<VMwareToAzStackHciProtectedNicProperties> protectedNics = null, string targetVmBiosId = null, string targetVmName = null, string hyperVGeneration = null, string targetNetworkId = null, string testNetworkId = null, int? targetCpuCores = null, bool? isDynamicRam = null, ProtectedItemDynamicMemoryConfig dynamicMemoryConfig = null, int? targetMemoryInMegaBytes = null, string osType = null, string osName = null, string firmwareType = null, ResourceIdentifier fabricDiscoveryMachineId = null, string sourceVmName = null, int? sourceCpuCores = null, double? sourceMemoryInMegaBytes = null, string runAsAccountId = null, string sourceDraName = null, string targetDraName = null, string sourceApplianceName = null, string targetApplianceName = null, string failoverRecoveryPointId = null, DateTimeOffset? lastRecoveryPointReceived = null, string lastRecoveryPointId = null, int? initialReplicationProgressPercentage = null, int? migrationProgressPercentage = null, int? resumeProgressPercentage = null, int? resyncProgressPercentage = null, long? resyncRetryCount = null, bool? resyncRequired = null, VMwareToAzureMigrateResyncState? resyncState = null, bool? performAutoResync = null, long? resumeRetryCount = null, DateTimeOffset? lastReplicationUpdateOn = null)
        {
            disksToInclude ??= new List<VMwareToAzStackHciDiskInput>();
            nicsToInclude ??= new List<VMwareToAzStackHciNicInput>();
            protectedDisks ??= new List<VMwareToAzStackHciProtectedDiskProperties>();
            protectedNics ??= new List<VMwareToAzStackHciProtectedNicProperties>();

            return new VMwareToAzStackHciProtectedItemModelCustomProperties(
                "VMwareToAzStackHCI",
                serializedAdditionalRawData: null,
                activeLocation,
                targetHciClusterId,
                targetArcClusterCustomLocationId,
                targetAzStackHciClusterName,
                storageContainerId,
                targetResourceGroupId,
                targetLocation,
                customLocationRegion,
                disksToInclude?.ToList(),
                nicsToInclude?.ToList(),
                protectedDisks?.ToList(),
                protectedNics?.ToList(),
                targetVmBiosId,
                targetVmName,
                hyperVGeneration,
                targetNetworkId,
                testNetworkId,
                targetCpuCores,
                isDynamicRam,
                dynamicMemoryConfig,
                targetMemoryInMegaBytes,
                osType,
                osName,
                firmwareType,
                fabricDiscoveryMachineId,
                sourceVmName,
                sourceCpuCores,
                sourceMemoryInMegaBytes,
                runAsAccountId,
                sourceDraName,
                targetDraName,
                sourceApplianceName,
                targetApplianceName,
                failoverRecoveryPointId,
                lastRecoveryPointReceived,
                lastRecoveryPointId,
                initialReplicationProgressPercentage,
                migrationProgressPercentage,
                resumeProgressPercentage,
                resyncProgressPercentage,
                resyncRetryCount,
                resyncRequired,
                resyncState,
                performAutoResync,
                resumeRetryCount,
                lastReplicationUpdateOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareToAzStackHciProtectedNicProperties"/>. </summary>
        /// <param name="nicId"> Gets or sets the NIC Id. </param>
        /// <param name="macAddress"> Gets or sets the NIC mac address. </param>
        /// <param name="label"> Gets or sets the NIC label. </param>
        /// <param name="isPrimaryNic"> Gets or sets a value indicating whether this is the primary NIC. </param>
        /// <param name="networkName"> Gets or sets the network name. </param>
        /// <param name="targetNetworkId"> Gets or sets the target network Id within AzStackHCI Cluster. </param>
        /// <param name="testNetworkId"> Gets or sets the target test network Id within AzStackHCI Cluster. </param>
        /// <param name="selectionTypeForFailover"> Gets or sets the selection type of the NIC. </param>
        /// <returns> A new <see cref="Models.VMwareToAzStackHciProtectedNicProperties"/> instance for mocking. </returns>
        public static VMwareToAzStackHciProtectedNicProperties VMwareToAzStackHciProtectedNicProperties(string nicId = null, string macAddress = null, string label = null, bool? isPrimaryNic = null, string networkName = null, string targetNetworkId = null, string testNetworkId = null, VmNicSelection? selectionTypeForFailover = null)
        {
            return new VMwareToAzStackHciProtectedNicProperties(
                nicId,
                macAddress,
                label,
                isPrimaryNic,
                networkName,
                targetNetworkId,
                testNetworkId,
                selectionTypeForFailover,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareToAzStackHciReplicationExtensionModelCustomProperties"/>. </summary>
        /// <param name="vmwareFabricArmId"> Gets or sets the ARM Id of the source VMware fabric. </param>
        /// <param name="vmwareSiteId"> Gets or sets the ARM Id of the VMware site. </param>
        /// <param name="azStackHciFabricArmId"> Gets or sets the ARM Id of the target AzStackHCI fabric. </param>
        /// <param name="azStackHciSiteId"> Gets or sets the ARM Id of the AzStackHCI site. </param>
        /// <param name="storageAccountId"> Gets or sets the storage account Id. </param>
        /// <param name="storageAccountSasSecretName"> Gets or sets the Sas Secret of storage account. </param>
        /// <param name="asrServiceUri"> Gets or sets the Uri of ASR. </param>
        /// <param name="rcmServiceUri"> Gets or sets the Uri of Rcm. </param>
        /// <param name="gatewayServiceUri"> Gets or sets the Uri of Gateway. </param>
        /// <param name="sourceGatewayServiceId"> Gets or sets the gateway service Id of source. </param>
        /// <param name="targetGatewayServiceId"> Gets or sets the gateway service Id of target. </param>
        /// <param name="sourceStorageContainerName"> Gets or sets the source storage container name. </param>
        /// <param name="targetStorageContainerName"> Gets or sets the target storage container name. </param>
        /// <param name="resourceLocation"> Gets or sets the resource location. </param>
        /// <param name="subscriptionId"> Gets or sets the subscription. </param>
        /// <param name="resourceGroup"> Gets or sets the resource group. </param>
        /// <returns> A new <see cref="Models.VMwareToAzStackHciReplicationExtensionModelCustomProperties"/> instance for mocking. </returns>
        public static VMwareToAzStackHciReplicationExtensionModelCustomProperties VMwareToAzStackHciReplicationExtensionModelCustomProperties(ResourceIdentifier vmwareFabricArmId = null, ResourceIdentifier vmwareSiteId = null, ResourceIdentifier azStackHciFabricArmId = null, ResourceIdentifier azStackHciSiteId = null, ResourceIdentifier storageAccountId = null, string storageAccountSasSecretName = null, Uri asrServiceUri = null, Uri rcmServiceUri = null, Uri gatewayServiceUri = null, string sourceGatewayServiceId = null, string targetGatewayServiceId = null, string sourceStorageContainerName = null, string targetStorageContainerName = null, string resourceLocation = null, string subscriptionId = null, string resourceGroup = null)
        {
            return new VMwareToAzStackHciReplicationExtensionModelCustomProperties(
                "VMwareToAzStackHCI",
                serializedAdditionalRawData: null,
                vmwareFabricArmId,
                vmwareSiteId,
                azStackHciFabricArmId,
                azStackHciSiteId,
                storageAccountId,
                storageAccountSasSecretName,
                asrServiceUri,
                rcmServiceUri,
                gatewayServiceUri,
                sourceGatewayServiceId,
                targetGatewayServiceId,
                sourceStorageContainerName,
                targetStorageContainerName,
                resourceLocation,
                subscriptionId,
                resourceGroup);
        }
    }
}
