// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesDataReplication.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Samples
{
    public partial class Sample_ResourceGroupResourceExtensions
    {
        // DeploymentPreflight
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeploymentPreflight_DeploymentPreflight()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/DeploymentPreflight.json
            // this example is just showing the usage of "DeploymentPreflight" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // invoke the operation
            string deploymentId = "kjoiahxljomjcmvabaobumg";
            DeploymentPreflightModel body = new DeploymentPreflightModel()
            {
                Resources =
{
new DeploymentPreflightResourceInfo()
{
Name = "xtgugoflfc",
DeploymentPreflightResourceType = new ResourceType("nsnaptduolqcxsikrewvgjbxqpt"),
Location = new AzureLocation("cbsgtxkjdzwbyp"),
ApiVersion = "otihymhvzblycdoxo",
}
},
            };
            DeploymentPreflightModel result = await resourceGroupResource.DeploymentPreflightAsync(deploymentId, body: body);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
