// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesDataReplication.Models;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Samples
{
    public partial class Sample_DataReplicationReplicationExtensionResource
    {
        // ReplicationExtension_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ReplicationExtensionGet()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/ReplicationExtension_Get.json
            // this example is just showing the usage of "ReplicationExtension_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationReplicationExtensionResource created on azure
            // for more information of creating DataReplicationReplicationExtensionResource, please refer to the document of DataReplicationReplicationExtensionResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string vaultName = "4";
            string replicationExtensionName = "g16yjJ";
            ResourceIdentifier dataReplicationReplicationExtensionResourceId = DataReplicationReplicationExtensionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, replicationExtensionName);
            DataReplicationReplicationExtensionResource dataReplicationReplicationExtension = client.GetDataReplicationReplicationExtensionResource(dataReplicationReplicationExtensionResourceId);

            // invoke the operation
            DataReplicationReplicationExtensionResource result = await dataReplicationReplicationExtension.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataReplicationReplicationExtensionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ReplicationExtension_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ReplicationExtensionCreate()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/ReplicationExtension_Create.json
            // this example is just showing the usage of "ReplicationExtension_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationReplicationExtensionResource created on azure
            // for more information of creating DataReplicationReplicationExtensionResource, please refer to the document of DataReplicationReplicationExtensionResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string vaultName = "4";
            string replicationExtensionName = "g16yjJ";
            ResourceIdentifier dataReplicationReplicationExtensionResourceId = DataReplicationReplicationExtensionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, replicationExtensionName);
            DataReplicationReplicationExtensionResource dataReplicationReplicationExtension = client.GetDataReplicationReplicationExtensionResource(dataReplicationReplicationExtensionResourceId);

            // invoke the operation
            DataReplicationReplicationExtensionData data = new DataReplicationReplicationExtensionData(new DataReplicationReplicationExtensionProperties(new GeneralReplicationExtensionModelCustomProperties()));
            ArmOperation<DataReplicationReplicationExtensionResource> lro = await dataReplicationReplicationExtension.UpdateAsync(WaitUntil.Completed, data);
            DataReplicationReplicationExtensionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataReplicationReplicationExtensionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ReplicationExtension_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ReplicationExtensionDelete()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/ReplicationExtension_Delete.json
            // this example is just showing the usage of "ReplicationExtension_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationReplicationExtensionResource created on azure
            // for more information of creating DataReplicationReplicationExtensionResource, please refer to the document of DataReplicationReplicationExtensionResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string vaultName = "4";
            string replicationExtensionName = "g16yjJ";
            ResourceIdentifier dataReplicationReplicationExtensionResourceId = DataReplicationReplicationExtensionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, replicationExtensionName);
            DataReplicationReplicationExtensionResource dataReplicationReplicationExtension = client.GetDataReplicationReplicationExtensionResource(dataReplicationReplicationExtensionResourceId);

            // invoke the operation
            await dataReplicationReplicationExtension.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
