// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesDataReplication.Models;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Samples
{
    public partial class Sample_DataReplicationEmailConfigurationResource
    {
        // EmailConfiguration_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_EmailConfigurationGet()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/EmailConfiguration_Get.json
            // this example is just showing the usage of "EmailConfiguration_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationEmailConfigurationResource created on azure
            // for more information of creating DataReplicationEmailConfigurationResource, please refer to the document of DataReplicationEmailConfigurationResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string vaultName = "4";
            string emailConfigurationName = "0";
            ResourceIdentifier dataReplicationEmailConfigurationResourceId = DataReplicationEmailConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, emailConfigurationName);
            DataReplicationEmailConfigurationResource dataReplicationEmailConfiguration = client.GetDataReplicationEmailConfigurationResource(dataReplicationEmailConfigurationResourceId);

            // invoke the operation
            DataReplicationEmailConfigurationResource result = await dataReplicationEmailConfiguration.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataReplicationEmailConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // EmailConfiguration_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_EmailConfigurationCreate()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/EmailConfiguration_Create.json
            // this example is just showing the usage of "EmailConfiguration_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationEmailConfigurationResource created on azure
            // for more information of creating DataReplicationEmailConfigurationResource, please refer to the document of DataReplicationEmailConfigurationResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string vaultName = "4";
            string emailConfigurationName = "0";
            ResourceIdentifier dataReplicationEmailConfigurationResourceId = DataReplicationEmailConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, emailConfigurationName);
            DataReplicationEmailConfigurationResource dataReplicationEmailConfiguration = client.GetDataReplicationEmailConfigurationResource(dataReplicationEmailConfigurationResourceId);

            // invoke the operation
            DataReplicationEmailConfigurationData data = new DataReplicationEmailConfigurationData(new DataReplicationEmailConfigurationProperties(true)
            {
                CustomEmailAddresses =
{
"ketvbducyailcny"
},
                Locale = "vpnjxjvdqtebnucyxiyrjiko",
            });
            ArmOperation<DataReplicationEmailConfigurationResource> lro = await dataReplicationEmailConfiguration.UpdateAsync(WaitUntil.Completed, data);
            DataReplicationEmailConfigurationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataReplicationEmailConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
