// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesDataReplication.Models;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Samples
{
    public partial class Sample_DataReplicationDraResource
    {
        // Dra_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_DraGet()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Dra_Get.json
            // this example is just showing the usage of "Dra_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationDraResource created on azure
            // for more information of creating DataReplicationDraResource, please refer to the document of DataReplicationDraResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string fabricName = "wPR";
            string fabricAgentName = "M";
            ResourceIdentifier dataReplicationDraResourceId = DataReplicationDraResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fabricName, fabricAgentName);
            DataReplicationDraResource dataReplicationDra = client.GetDataReplicationDraResource(dataReplicationDraResourceId);

            // invoke the operation
            DataReplicationDraResource result = await dataReplicationDra.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataReplicationDraData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Dra_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_DraCreate()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Dra_Create.json
            // this example is just showing the usage of "Dra_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationDraResource created on azure
            // for more information of creating DataReplicationDraResource, please refer to the document of DataReplicationDraResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string fabricName = "wPR";
            string fabricAgentName = "M";
            ResourceIdentifier dataReplicationDraResourceId = DataReplicationDraResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fabricName, fabricAgentName);
            DataReplicationDraResource dataReplicationDra = client.GetDataReplicationDraResource(dataReplicationDraResourceId);

            // invoke the operation
            DataReplicationDraData data = new DataReplicationDraData(new DataReplicationDraProperties("envzcoijbqhtrpncbjbhk", "y", new DataReplicationIdentity(Guid.Parse("joclkkdovixwapephhxaqtefubhhmq"), "cwktzrwajuvfyyymfstpey", "khsiaqfbpuhp", "dkjobanyqgzenivyxhvavottpc", "bubwwbowfhdmujrt"), new DataReplicationIdentity(Guid.Parse("joclkkdovixwapephhxaqtefubhhmq"), "cwktzrwajuvfyyymfstpey", "khsiaqfbpuhp", "dkjobanyqgzenivyxhvavottpc", "bubwwbowfhdmujrt"), new GeneralDraModelCustomProperties()));
            ArmOperation<DataReplicationDraResource> lro = await dataReplicationDra.UpdateAsync(WaitUntil.Completed, data);
            DataReplicationDraResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataReplicationDraData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Dra_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DraDelete()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Dra_Delete.json
            // this example is just showing the usage of "Dra_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationDraResource created on azure
            // for more information of creating DataReplicationDraResource, please refer to the document of DataReplicationDraResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string fabricName = "wPR";
            string fabricAgentName = "M";
            ResourceIdentifier dataReplicationDraResourceId = DataReplicationDraResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fabricName, fabricAgentName);
            DataReplicationDraResource dataReplicationDra = client.GetDataReplicationDraResource(dataReplicationDraResourceId);

            // invoke the operation
            await dataReplicationDra.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
