// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesDataReplication.Models;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Samples
{
    public partial class Sample_DataReplicationDraCollection
    {
        // Dra_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_DraGet()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Dra_Get.json
            // this example is just showing the usage of "Dra_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationFabricResource created on azure
            // for more information of creating DataReplicationFabricResource, please refer to the document of DataReplicationFabricResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string fabricName = "wPR";
            ResourceIdentifier dataReplicationFabricResourceId = DataReplicationFabricResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fabricName);
            DataReplicationFabricResource dataReplicationFabric = client.GetDataReplicationFabricResource(dataReplicationFabricResourceId);

            // get the collection of this DataReplicationDraResource
            DataReplicationDraCollection collection = dataReplicationFabric.GetDataReplicationDras();

            // invoke the operation
            string fabricAgentName = "M";
            DataReplicationDraResource result = await collection.GetAsync(fabricAgentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataReplicationDraData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Dra_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_DraGet()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Dra_Get.json
            // this example is just showing the usage of "Dra_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationFabricResource created on azure
            // for more information of creating DataReplicationFabricResource, please refer to the document of DataReplicationFabricResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string fabricName = "wPR";
            ResourceIdentifier dataReplicationFabricResourceId = DataReplicationFabricResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fabricName);
            DataReplicationFabricResource dataReplicationFabric = client.GetDataReplicationFabricResource(dataReplicationFabricResourceId);

            // get the collection of this DataReplicationDraResource
            DataReplicationDraCollection collection = dataReplicationFabric.GetDataReplicationDras();

            // invoke the operation
            string fabricAgentName = "M";
            bool result = await collection.ExistsAsync(fabricAgentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Dra_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_DraGet()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Dra_Get.json
            // this example is just showing the usage of "Dra_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationFabricResource created on azure
            // for more information of creating DataReplicationFabricResource, please refer to the document of DataReplicationFabricResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string fabricName = "wPR";
            ResourceIdentifier dataReplicationFabricResourceId = DataReplicationFabricResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fabricName);
            DataReplicationFabricResource dataReplicationFabric = client.GetDataReplicationFabricResource(dataReplicationFabricResourceId);

            // get the collection of this DataReplicationDraResource
            DataReplicationDraCollection collection = dataReplicationFabric.GetDataReplicationDras();

            // invoke the operation
            string fabricAgentName = "M";
            NullableResponse<DataReplicationDraResource> response = await collection.GetIfExistsAsync(fabricAgentName);
            DataReplicationDraResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataReplicationDraData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Dra_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_DraCreate()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Dra_Create.json
            // this example is just showing the usage of "Dra_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationFabricResource created on azure
            // for more information of creating DataReplicationFabricResource, please refer to the document of DataReplicationFabricResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string fabricName = "wPR";
            ResourceIdentifier dataReplicationFabricResourceId = DataReplicationFabricResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fabricName);
            DataReplicationFabricResource dataReplicationFabric = client.GetDataReplicationFabricResource(dataReplicationFabricResourceId);

            // get the collection of this DataReplicationDraResource
            DataReplicationDraCollection collection = dataReplicationFabric.GetDataReplicationDras();

            // invoke the operation
            string fabricAgentName = "M";
            DataReplicationDraData data = new DataReplicationDraData(new DataReplicationDraProperties("envzcoijbqhtrpncbjbhk", "y", new DataReplicationIdentity(Guid.Parse("joclkkdovixwapephhxaqtefubhhmq"), "cwktzrwajuvfyyymfstpey", "khsiaqfbpuhp", "dkjobanyqgzenivyxhvavottpc", "bubwwbowfhdmujrt"), new DataReplicationIdentity(Guid.Parse("joclkkdovixwapephhxaqtefubhhmq"), "cwktzrwajuvfyyymfstpey", "khsiaqfbpuhp", "dkjobanyqgzenivyxhvavottpc", "bubwwbowfhdmujrt"), new GeneralDraModelCustomProperties()));
            ArmOperation<DataReplicationDraResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, fabricAgentName, data);
            DataReplicationDraResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataReplicationDraData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Dra_List
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_DraList()
        {
            // Generated from example definition: specification/recoveryservicesdatareplication/resource-manager/Microsoft.DataReplication/preview/2021-02-16-preview/examples/Dra_List.json
            // this example is just showing the usage of "Dra_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataReplicationFabricResource created on azure
            // for more information of creating DataReplicationFabricResource, please refer to the document of DataReplicationFabricResource
            string subscriptionId = "930CEC23-4430-4513-B855-DBA237E2F3BF";
            string resourceGroupName = "rgrecoveryservicesdatareplication";
            string fabricName = "wPR";
            ResourceIdentifier dataReplicationFabricResourceId = DataReplicationFabricResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fabricName);
            DataReplicationFabricResource dataReplicationFabric = client.GetDataReplicationFabricResource(dataReplicationFabricResourceId);

            // get the collection of this DataReplicationDraResource
            DataReplicationDraCollection collection = dataReplicationFabric.GetDataReplicationDras();

            // invoke the operation and iterate over the result
            await foreach (DataReplicationDraResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataReplicationDraData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
