// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Extended info class details. </summary>
    public partial class WorkloadSqlRecoveryPointExtendedInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WorkloadSqlRecoveryPointExtendedInfo"/>. </summary>
        public WorkloadSqlRecoveryPointExtendedInfo()
        {
            DataDirectoryPaths = new ChangeTrackingList<SqlDataDirectory>();
        }

        /// <summary> Initializes a new instance of <see cref="WorkloadSqlRecoveryPointExtendedInfo"/>. </summary>
        /// <param name="dataDirectoryInfoCapturedOn"> UTC time at which data directory info was captured. </param>
        /// <param name="dataDirectoryPaths"> List of data directory paths during restore operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WorkloadSqlRecoveryPointExtendedInfo(DateTimeOffset? dataDirectoryInfoCapturedOn, IList<SqlDataDirectory> dataDirectoryPaths, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DataDirectoryInfoCapturedOn = dataDirectoryInfoCapturedOn;
            DataDirectoryPaths = dataDirectoryPaths;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> UTC time at which data directory info was captured. </summary>
        public DateTimeOffset? DataDirectoryInfoCapturedOn { get; set; }
        /// <summary> List of data directory paths during restore operation. </summary>
        public IList<SqlDataDirectory> DataDirectoryPaths { get; }
    }
}
