// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary>
    /// Workload specific recovery point, specifically encapsulates full/diff recovery point
    /// Please note <see cref="WorkloadRecoveryPoint"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="WorkloadPointInTimeRecoveryPoint"/>, <see cref="WorkloadSapHanaPointInTimeRecoveryPoint"/>, <see cref="WorkloadSapHanaRecoveryPoint"/>, <see cref="WorkloadSqlPointInTimeRecoveryPoint"/> and <see cref="WorkloadSqlRecoveryPoint"/>.
    /// </summary>
    public partial class WorkloadRecoveryPoint : BackupGenericRecoveryPoint
    {
        /// <summary> Initializes a new instance of <see cref="WorkloadRecoveryPoint"/>. </summary>
        public WorkloadRecoveryPoint()
        {
            RecoveryPointTierDetails = new ChangeTrackingList<RecoveryPointTierInformationV2>();
            RecoveryPointMoveReadinessInfo = new ChangeTrackingDictionary<string, RecoveryPointMoveReadinessInfo>();
            ObjectType = "AzureWorkloadRecoveryPoint";
        }

        /// <summary> Initializes a new instance of <see cref="WorkloadRecoveryPoint"/>. </summary>
        /// <param name="objectType"> This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recoveryPointCreatedOn"> UTC time at which recovery point was created. </param>
        /// <param name="restorePointType"> Type of restore point. </param>
        /// <param name="recoveryPointTierDetails"> Recovery point tier information. </param>
        /// <param name="recoveryPointMoveReadinessInfo"> Eligibility of RP to be moved to another tier. </param>
        /// <param name="recoveryPointProperties"> Properties of Recovery Point. </param>
        internal WorkloadRecoveryPoint(string objectType, IDictionary<string, BinaryData> serializedAdditionalRawData, DateTimeOffset? recoveryPointCreatedOn, RestorePointType? restorePointType, IList<RecoveryPointTierInformationV2> recoveryPointTierDetails, IDictionary<string, RecoveryPointMoveReadinessInfo> recoveryPointMoveReadinessInfo, RecoveryPointProperties recoveryPointProperties) : base(objectType, serializedAdditionalRawData)
        {
            RecoveryPointCreatedOn = recoveryPointCreatedOn;
            RestorePointType = restorePointType;
            RecoveryPointTierDetails = recoveryPointTierDetails;
            RecoveryPointMoveReadinessInfo = recoveryPointMoveReadinessInfo;
            RecoveryPointProperties = recoveryPointProperties;
            ObjectType = objectType ?? "AzureWorkloadRecoveryPoint";
        }

        /// <summary> UTC time at which recovery point was created. </summary>
        public DateTimeOffset? RecoveryPointCreatedOn { get; set; }
        /// <summary> Type of restore point. </summary>
        public RestorePointType? RestorePointType { get; set; }
        /// <summary> Recovery point tier information. </summary>
        public IList<RecoveryPointTierInformationV2> RecoveryPointTierDetails { get; }
        /// <summary> Eligibility of RP to be moved to another tier. </summary>
        public IDictionary<string, RecoveryPointMoveReadinessInfo> RecoveryPointMoveReadinessInfo { get; }
        /// <summary> Properties of Recovery Point. </summary>
        public RecoveryPointProperties RecoveryPointProperties { get; set; }
    }
}
