// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Re-Do Operation. </summary>
    public readonly partial struct WorkloadOperationType : IEquatable<WorkloadOperationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkloadOperationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkloadOperationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string RegisterValue = "Register";
        private const string ReregisterValue = "Reregister";

        /// <summary> Invalid. </summary>
        public static WorkloadOperationType Invalid { get; } = new WorkloadOperationType(InvalidValue);
        /// <summary> Register. </summary>
        public static WorkloadOperationType Register { get; } = new WorkloadOperationType(RegisterValue);
        /// <summary> Reregister. </summary>
        public static WorkloadOperationType Reregister { get; } = new WorkloadOperationType(ReregisterValue);
        /// <summary> Determines if two <see cref="WorkloadOperationType"/> values are the same. </summary>
        public static bool operator ==(WorkloadOperationType left, WorkloadOperationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkloadOperationType"/> values are not the same. </summary>
        public static bool operator !=(WorkloadOperationType left, WorkloadOperationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkloadOperationType"/>. </summary>
        public static implicit operator WorkloadOperationType(string value) => new WorkloadOperationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkloadOperationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkloadOperationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
