// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Workload item type of the item for which intent is to be set. </summary>
    public readonly partial struct WorkloadItemType : IEquatable<WorkloadItemType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkloadItemType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkloadItemType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string SqlInstanceValue = "SQLInstance";
        private const string SqlDatabaseValue = "SQLDataBase";
        private const string SapHanaSystemValue = "SAPHanaSystem";
        private const string SapHanaDatabaseValue = "SAPHanaDatabase";
        private const string SapAseSystemValue = "SAPAseSystem";
        private const string SapAseDatabaseValue = "SAPAseDatabase";
        private const string SapHanaDBInstanceValue = "SAPHanaDBInstance";

        /// <summary> Invalid. </summary>
        public static WorkloadItemType Invalid { get; } = new WorkloadItemType(InvalidValue);
        /// <summary> SQLInstance. </summary>
        public static WorkloadItemType SqlInstance { get; } = new WorkloadItemType(SqlInstanceValue);
        /// <summary> SQLDataBase. </summary>
        public static WorkloadItemType SqlDatabase { get; } = new WorkloadItemType(SqlDatabaseValue);
        /// <summary> SAPHanaSystem. </summary>
        public static WorkloadItemType SapHanaSystem { get; } = new WorkloadItemType(SapHanaSystemValue);
        /// <summary> SAPHanaDatabase. </summary>
        public static WorkloadItemType SapHanaDatabase { get; } = new WorkloadItemType(SapHanaDatabaseValue);
        /// <summary> SAPAseSystem. </summary>
        public static WorkloadItemType SapAseSystem { get; } = new WorkloadItemType(SapAseSystemValue);
        /// <summary> SAPAseDatabase. </summary>
        public static WorkloadItemType SapAseDatabase { get; } = new WorkloadItemType(SapAseDatabaseValue);
        /// <summary> SAPHanaDBInstance. </summary>
        public static WorkloadItemType SapHanaDBInstance { get; } = new WorkloadItemType(SapHanaDBInstanceValue);
        /// <summary> Determines if two <see cref="WorkloadItemType"/> values are the same. </summary>
        public static bool operator ==(WorkloadItemType left, WorkloadItemType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkloadItemType"/> values are not the same. </summary>
        public static bool operator !=(WorkloadItemType left, WorkloadItemType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkloadItemType"/>. </summary>
        public static implicit operator WorkloadItemType(string value) => new WorkloadItemType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkloadItemType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkloadItemType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
