// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class WorkloadInquiryDetails : IUtf8JsonSerializable, IJsonModel<WorkloadInquiryDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<WorkloadInquiryDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<WorkloadInquiryDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WorkloadInquiryDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(WorkloadInquiryDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(WorkloadInquiryDetailsType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(WorkloadInquiryDetailsType);
            }
            if (Optional.IsDefined(ItemCount))
            {
                writer.WritePropertyName("itemCount"u8);
                writer.WriteNumberValue(ItemCount.Value);
            }
            if (Optional.IsDefined(InquiryValidation))
            {
                writer.WritePropertyName("inquiryValidation"u8);
                writer.WriteObjectValue(InquiryValidation, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        WorkloadInquiryDetails IJsonModel<WorkloadInquiryDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WorkloadInquiryDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(WorkloadInquiryDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeWorkloadInquiryDetails(document.RootElement, options);
        }

        internal static WorkloadInquiryDetails DeserializeWorkloadInquiryDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string type = default;
            long? itemCount = default;
            InquiryValidation inquiryValidation = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("itemCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    itemCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("inquiryValidation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    inquiryValidation = InquiryValidation.DeserializeInquiryValidation(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new WorkloadInquiryDetails(type, itemCount, inquiryValidation, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<WorkloadInquiryDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WorkloadInquiryDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(WorkloadInquiryDetails)} does not support writing '{options.Format}' format.");
            }
        }

        WorkloadInquiryDetails IPersistableModel<WorkloadInquiryDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WorkloadInquiryDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeWorkloadInquiryDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(WorkloadInquiryDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<WorkloadInquiryDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
