// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Health status of the backup item, evaluated based on last heartbeat received. </summary>
    public readonly partial struct VmWorkloadProtectedItemHealthStatus : IEquatable<VmWorkloadProtectedItemHealthStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VmWorkloadProtectedItemHealthStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VmWorkloadProtectedItemHealthStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string HealthyValue = "Healthy";
        private const string UnhealthyValue = "Unhealthy";
        private const string NotReachableValue = "NotReachable";
        private const string IRPendingValue = "IRPending";

        /// <summary> Invalid. </summary>
        public static VmWorkloadProtectedItemHealthStatus Invalid { get; } = new VmWorkloadProtectedItemHealthStatus(InvalidValue);
        /// <summary> Healthy. </summary>
        public static VmWorkloadProtectedItemHealthStatus Healthy { get; } = new VmWorkloadProtectedItemHealthStatus(HealthyValue);
        /// <summary> Unhealthy. </summary>
        public static VmWorkloadProtectedItemHealthStatus Unhealthy { get; } = new VmWorkloadProtectedItemHealthStatus(UnhealthyValue);
        /// <summary> NotReachable. </summary>
        public static VmWorkloadProtectedItemHealthStatus NotReachable { get; } = new VmWorkloadProtectedItemHealthStatus(NotReachableValue);
        /// <summary> IRPending. </summary>
        public static VmWorkloadProtectedItemHealthStatus IRPending { get; } = new VmWorkloadProtectedItemHealthStatus(IRPendingValue);
        /// <summary> Determines if two <see cref="VmWorkloadProtectedItemHealthStatus"/> values are the same. </summary>
        public static bool operator ==(VmWorkloadProtectedItemHealthStatus left, VmWorkloadProtectedItemHealthStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VmWorkloadProtectedItemHealthStatus"/> values are not the same. </summary>
        public static bool operator !=(VmWorkloadProtectedItemHealthStatus left, VmWorkloadProtectedItemHealthStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VmWorkloadProtectedItemHealthStatus"/>. </summary>
        public static implicit operator VmWorkloadProtectedItemHealthStatus(string value) => new VmWorkloadProtectedItemHealthStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VmWorkloadProtectedItemHealthStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VmWorkloadProtectedItemHealthStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
