// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Details needed if the VM was encrypted at the time of backup. </summary>
    public partial class VmEncryptionDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VmEncryptionDetails"/>. </summary>
        public VmEncryptionDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VmEncryptionDetails"/>. </summary>
        /// <param name="isEncryptionEnabled"> Identifies whether this backup copy represents an encrypted VM at the time of backup. </param>
        /// <param name="kekUri"> Key Url. </param>
        /// <param name="secretKeyUri"> Secret Url. </param>
        /// <param name="kekVaultId"> ID of Key Vault where KEK is stored. </param>
        /// <param name="secretKeyVaultId"> ID of Key Vault where Secret is stored. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VmEncryptionDetails(bool? isEncryptionEnabled, Uri kekUri, Uri secretKeyUri, ResourceIdentifier kekVaultId, ResourceIdentifier secretKeyVaultId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEncryptionEnabled = isEncryptionEnabled;
            KekUri = kekUri;
            SecretKeyUri = secretKeyUri;
            KekVaultId = kekVaultId;
            SecretKeyVaultId = secretKeyVaultId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Identifies whether this backup copy represents an encrypted VM at the time of backup. </summary>
        public bool? IsEncryptionEnabled { get; set; }
        /// <summary> Key Url. </summary>
        public Uri KekUri { get; set; }
        /// <summary> Secret Url. </summary>
        public Uri SecretKeyUri { get; set; }
        /// <summary> ID of Key Vault where KEK is stored. </summary>
        public ResourceIdentifier KekVaultId { get; set; }
        /// <summary> ID of Key Vault where Secret is stored. </summary>
        public ResourceIdentifier SecretKeyVaultId { get; set; }
    }
}
