// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class VmEncryptionDetails : IUtf8JsonSerializable, IJsonModel<VmEncryptionDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VmEncryptionDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VmEncryptionDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VmEncryptionDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VmEncryptionDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(IsEncryptionEnabled))
            {
                writer.WritePropertyName("encryptionEnabled"u8);
                writer.WriteBooleanValue(IsEncryptionEnabled.Value);
            }
            if (Optional.IsDefined(KekUri))
            {
                writer.WritePropertyName("kekUrl"u8);
                writer.WriteStringValue(KekUri.AbsoluteUri);
            }
            if (Optional.IsDefined(SecretKeyUri))
            {
                writer.WritePropertyName("secretKeyUrl"u8);
                writer.WriteStringValue(SecretKeyUri.AbsoluteUri);
            }
            if (Optional.IsDefined(KekVaultId))
            {
                writer.WritePropertyName("kekVaultId"u8);
                writer.WriteStringValue(KekVaultId);
            }
            if (Optional.IsDefined(SecretKeyVaultId))
            {
                writer.WritePropertyName("secretKeyVaultId"u8);
                writer.WriteStringValue(SecretKeyVaultId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VmEncryptionDetails IJsonModel<VmEncryptionDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VmEncryptionDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VmEncryptionDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVmEncryptionDetails(document.RootElement, options);
        }

        internal static VmEncryptionDetails DeserializeVmEncryptionDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? encryptionEnabled = default;
            Uri kekUrl = default;
            Uri secretKeyUrl = default;
            ResourceIdentifier kekVaultId = default;
            ResourceIdentifier secretKeyVaultId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("encryptionEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    encryptionEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("kekUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    kekUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("secretKeyUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    secretKeyUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("kekVaultId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    kekVaultId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("secretKeyVaultId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    secretKeyVaultId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VmEncryptionDetails(
                encryptionEnabled,
                kekUrl,
                secretKeyUrl,
                kekVaultId,
                secretKeyVaultId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VmEncryptionDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VmEncryptionDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VmEncryptionDetails)} does not support writing '{options.Format}' format.");
            }
        }

        VmEncryptionDetails IPersistableModel<VmEncryptionDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VmEncryptionDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVmEncryptionDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VmEncryptionDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VmEncryptionDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
