// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Vault x-cool state. </summary>
    public readonly partial struct VaultXcoolState : IEquatable<VaultXcoolState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VaultXcoolState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VaultXcoolState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Invalid. </summary>
        public static VaultXcoolState Invalid { get; } = new VaultXcoolState(InvalidValue);
        /// <summary> Enabled. </summary>
        public static VaultXcoolState Enabled { get; } = new VaultXcoolState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static VaultXcoolState Disabled { get; } = new VaultXcoolState(DisabledValue);
        /// <summary> Determines if two <see cref="VaultXcoolState"/> values are the same. </summary>
        public static bool operator ==(VaultXcoolState left, VaultXcoolState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VaultXcoolState"/> values are not the same. </summary>
        public static bool operator !=(VaultXcoolState left, VaultXcoolState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VaultXcoolState"/>. </summary>
        public static implicit operator VaultXcoolState(string value) => new VaultXcoolState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VaultXcoolState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VaultXcoolState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
