// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Vault retention policy for AzureFileShare. </summary>
    public partial class VaultRetentionPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VaultRetentionPolicy"/>. </summary>
        /// <param name="vaultRetention">
        /// Base class for retention policy.
        /// Please note <see cref="BackupRetentionPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LongTermRetentionPolicy"/> and <see cref="SimpleRetentionPolicy"/>.
        /// </param>
        /// <param name="snapshotRetentionInDays"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="vaultRetention"/> is null. </exception>
        public VaultRetentionPolicy(BackupRetentionPolicy vaultRetention, int snapshotRetentionInDays)
        {
            Argument.AssertNotNull(vaultRetention, nameof(vaultRetention));

            VaultRetention = vaultRetention;
            SnapshotRetentionInDays = snapshotRetentionInDays;
        }

        /// <summary> Initializes a new instance of <see cref="VaultRetentionPolicy"/>. </summary>
        /// <param name="vaultRetention">
        /// Base class for retention policy.
        /// Please note <see cref="BackupRetentionPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LongTermRetentionPolicy"/> and <see cref="SimpleRetentionPolicy"/>.
        /// </param>
        /// <param name="snapshotRetentionInDays"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VaultRetentionPolicy(BackupRetentionPolicy vaultRetention, int snapshotRetentionInDays, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VaultRetention = vaultRetention;
            SnapshotRetentionInDays = snapshotRetentionInDays;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="VaultRetentionPolicy"/> for deserialization. </summary>
        internal VaultRetentionPolicy()
        {
        }

        /// <summary>
        /// Base class for retention policy.
        /// Please note <see cref="BackupRetentionPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LongTermRetentionPolicy"/> and <see cref="SimpleRetentionPolicy"/>.
        /// </summary>
        public BackupRetentionPolicy VaultRetention { get; set; }
        /// <summary> Gets or sets the snapshot retention in days. </summary>
        public int SnapshotRetentionInDays { get; set; }
    }
}
