// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Vault Dedup state. </summary>
    public readonly partial struct VaultDedupState : IEquatable<VaultDedupState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VaultDedupState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VaultDedupState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Invalid. </summary>
        public static VaultDedupState Invalid { get; } = new VaultDedupState(InvalidValue);
        /// <summary> Enabled. </summary>
        public static VaultDedupState Enabled { get; } = new VaultDedupState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static VaultDedupState Disabled { get; } = new VaultDedupState(DisabledValue);
        /// <summary> Determines if two <see cref="VaultDedupState"/> values are the same. </summary>
        public static bool operator ==(VaultDedupState left, VaultDedupState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VaultDedupState"/> values are not the same. </summary>
        public static bool operator !=(VaultDedupState left, VaultDedupState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VaultDedupState"/>. </summary>
        public static implicit operator VaultDedupState(string value) => new VaultDedupState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VaultDedupState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VaultDedupState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
