// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Vault level Job. </summary>
    public partial class VaultBackupJob : BackupGenericJob
    {
        /// <summary> Initializes a new instance of <see cref="VaultBackupJob"/>. </summary>
        public VaultBackupJob()
        {
            ActionsInfo = new ChangeTrackingList<JobSupportedAction>();
            ErrorDetails = new ChangeTrackingList<VaultBackupJobErrorInfo>();
            JobType = "VaultJob";
        }

        /// <summary> Initializes a new instance of <see cref="VaultBackupJob"/>. </summary>
        /// <param name="entityFriendlyName"> Friendly name of the entity on which the current job is executing. </param>
        /// <param name="backupManagementType"> Backup management type to execute the current job. </param>
        /// <param name="operation"> The operation name. </param>
        /// <param name="status"> Job status. </param>
        /// <param name="startOn"> The start time. </param>
        /// <param name="endOn"> The end time. </param>
        /// <param name="activityId"> ActivityId of job. </param>
        /// <param name="jobType"> This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="duration"> Time elapsed during the execution of this job. </param>
        /// <param name="actionsInfo"> Gets or sets the state/actions applicable on this job like cancel/retry. </param>
        /// <param name="errorDetails"> Error details on execution of this job. </param>
        /// <param name="extendedInfo"> Additional information about the job. </param>
        internal VaultBackupJob(string entityFriendlyName, BackupManagementType? backupManagementType, string operation, string status, DateTimeOffset? startOn, DateTimeOffset? endOn, string activityId, string jobType, IDictionary<string, BinaryData> serializedAdditionalRawData, TimeSpan? duration, IList<JobSupportedAction> actionsInfo, IList<VaultBackupJobErrorInfo> errorDetails, VaultBackupJobExtendedInfo extendedInfo) : base(entityFriendlyName, backupManagementType, operation, status, startOn, endOn, activityId, jobType, serializedAdditionalRawData)
        {
            Duration = duration;
            ActionsInfo = actionsInfo;
            ErrorDetails = errorDetails;
            ExtendedInfo = extendedInfo;
            JobType = jobType ?? "VaultJob";
        }

        /// <summary> Time elapsed during the execution of this job. </summary>
        public TimeSpan? Duration { get; set; }
        /// <summary> Gets or sets the state/actions applicable on this job like cancel/retry. </summary>
        public IList<JobSupportedAction> ActionsInfo { get; }
        /// <summary> Error details on execution of this job. </summary>
        public IList<VaultBackupJobErrorInfo> ErrorDetails { get; }
        /// <summary> Additional information about the job. </summary>
        internal VaultBackupJobExtendedInfo ExtendedInfo { get; set; }
        /// <summary> Job properties. </summary>
        public IDictionary<string, string> ExtendedInfoPropertyBag
        {
            get
            {
                if (ExtendedInfo is null)
                    ExtendedInfo = new VaultBackupJobExtendedInfo();
                return ExtendedInfo.PropertyBag;
            }
        }
    }
}
