// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> The UserAssignedManagedIdentityDetails. </summary>
    public partial class UserAssignedManagedIdentityDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UserAssignedManagedIdentityDetails"/>. </summary>
        public UserAssignedManagedIdentityDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UserAssignedManagedIdentityDetails"/>. </summary>
        /// <param name="identityArmId"></param>
        /// <param name="identityName"></param>
        /// <param name="userAssignedIdentityProperties"> User assigned identity properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UserAssignedManagedIdentityDetails(string identityArmId, string identityName, UserAssignedIdentity userAssignedIdentityProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IdentityArmId = identityArmId;
            IdentityName = identityName;
            UserAssignedIdentityProperties = userAssignedIdentityProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the identity arm id. </summary>
        public string IdentityArmId { get; set; }
        /// <summary> Gets or sets the identity name. </summary>
        public string IdentityName { get; set; }
        /// <summary> User assigned identity properties. </summary>
        public UserAssignedIdentity UserAssignedIdentityProperties { get; set; }
    }
}
