// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Unknown version of WorkloadProtectableItem. </summary>
    internal partial class UnknownWorkloadProtectableItem : WorkloadProtectableItem
    {
        /// <summary> Initializes a new instance of <see cref="UnknownWorkloadProtectableItem"/>. </summary>
        /// <param name="backupManagementType"> Type of backup management to backup an item. </param>
        /// <param name="workloadType"> Type of workload for the backup management. </param>
        /// <param name="protectableItemType"> Type of the backup item. </param>
        /// <param name="friendlyName"> Friendly name of the backup item. </param>
        /// <param name="protectionState"> State of the back up item. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownWorkloadProtectableItem(string backupManagementType, string workloadType, string protectableItemType, string friendlyName, BackupProtectionStatus? protectionState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(backupManagementType, workloadType, protectableItemType, friendlyName, protectionState, serializedAdditionalRawData)
        {
            ProtectableItemType = protectableItemType ?? "Unknown";
        }

        /// <summary> Initializes a new instance of <see cref="UnknownWorkloadProtectableItem"/> for deserialization. </summary>
        internal UnknownWorkloadProtectableItem()
        {
        }
    }
}
