// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Unknown version of FeatureSupportRequest. </summary>
    internal partial class UnknownFeatureSupportRequest : FeatureSupportContent
    {
        /// <summary> Initializes a new instance of <see cref="UnknownFeatureSupportRequest"/>. </summary>
        /// <param name="featureType"> backup support feature type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownFeatureSupportRequest(string featureType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(featureType, serializedAdditionalRawData)
        {
            FeatureType = featureType ?? "Unknown";
        }

        /// <summary> Initializes a new instance of <see cref="UnknownFeatureSupportRequest"/> for deserialization. </summary>
        internal UnknownFeatureSupportRequest()
        {
        }
    }
}
