// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Unknown version of BackupEngineBase. </summary>
    internal partial class UnknownBackupEngineBase : BackupGenericEngine
    {
        /// <summary> Initializes a new instance of <see cref="UnknownBackupEngineBase"/>. </summary>
        /// <param name="friendlyName"> Friendly name of the backup engine. </param>
        /// <param name="backupManagementType"> Type of backup management for the backup engine. </param>
        /// <param name="registrationStatus"> Registration status of the backup engine with the Recovery Services Vault. </param>
        /// <param name="backupEngineState"> Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}. </param>
        /// <param name="healthStatus"> Backup status of the backup engine. </param>
        /// <param name="backupEngineType"> Type of the backup engine. </param>
        /// <param name="canReRegister"> Flag indicating if the backup engine be registered, once already registered. </param>
        /// <param name="backupEngineId"> ID of the backup engine. </param>
        /// <param name="dpmVersion"> Backup engine version. </param>
        /// <param name="azureBackupAgentVersion"> Backup agent version. </param>
        /// <param name="isAzureBackupAgentUpgradeAvailable"> To check if backup agent upgrade available. </param>
        /// <param name="isDpmUpgradeAvailable"> To check if backup engine upgrade available. </param>
        /// <param name="extendedInfo"> Extended info of the backupengine. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownBackupEngineBase(string friendlyName, BackupManagementType? backupManagementType, string registrationStatus, string backupEngineState, string healthStatus, BackupEngineType backupEngineType, bool? canReRegister, string backupEngineId, string dpmVersion, string azureBackupAgentVersion, bool? isAzureBackupAgentUpgradeAvailable, bool? isDpmUpgradeAvailable, BackupEngineExtendedInfo extendedInfo, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(friendlyName, backupManagementType, registrationStatus, backupEngineState, healthStatus, backupEngineType, canReRegister, backupEngineId, dpmVersion, azureBackupAgentVersion, isAzureBackupAgentUpgradeAvailable, isDpmUpgradeAvailable, extendedInfo, serializedAdditionalRawData)
        {
            BackupEngineType = backupEngineType;
        }

        /// <summary> Initializes a new instance of <see cref="UnknownBackupEngineBase"/> for deserialization. </summary>
        internal UnknownBackupEngineBase()
        {
        }
    }
}
