// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary>
    /// Tiering Mode to control automatic tiering of recovery points. Supported values are:
    /// 1. TierRecommended: Tier all recovery points recommended to be tiered
    /// 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
    /// 3. DoNotTier: Do not tier any recovery points
    /// </summary>
    public readonly partial struct TieringMode : IEquatable<TieringMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TieringMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TieringMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string TierRecommendedValue = "TierRecommended";
        private const string TierAfterValue = "TierAfter";
        private const string DoNotTierValue = "DoNotTier";

        /// <summary> Invalid. </summary>
        public static TieringMode Invalid { get; } = new TieringMode(InvalidValue);
        /// <summary> TierRecommended. </summary>
        public static TieringMode TierRecommended { get; } = new TieringMode(TierRecommendedValue);
        /// <summary> TierAfter. </summary>
        public static TieringMode TierAfter { get; } = new TieringMode(TierAfterValue);
        /// <summary> DoNotTier. </summary>
        public static TieringMode DoNotTier { get; } = new TieringMode(DoNotTierValue);
        /// <summary> Determines if two <see cref="TieringMode"/> values are the same. </summary>
        public static bool operator ==(TieringMode left, TieringMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TieringMode"/> values are not the same. </summary>
        public static bool operator !=(TieringMode left, TieringMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TieringMode"/>. </summary>
        public static implicit operator TieringMode(string value) => new TieringMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TieringMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TieringMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
