// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class TieringCostSavingInfo : IUtf8JsonSerializable, IJsonModel<TieringCostSavingInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<TieringCostSavingInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<TieringCostSavingInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TieringCostSavingInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TieringCostSavingInfo)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("sourceTierSizeReductionInBytes"u8);
            writer.WriteNumberValue(SourceTierSizeReductionInBytes);
            writer.WritePropertyName("targetTierSizeIncreaseInBytes"u8);
            writer.WriteNumberValue(TargetTierSizeIncreaseInBytes);
            writer.WritePropertyName("retailSourceTierCostPerGBPerMonth"u8);
            writer.WriteNumberValue(RetailSourceTierCostPerGBPerMonth);
            writer.WritePropertyName("retailTargetTierCostPerGBPerMonth"u8);
            writer.WriteNumberValue(RetailTargetTierCostPerGBPerMonth);
        }

        TieringCostSavingInfo IJsonModel<TieringCostSavingInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TieringCostSavingInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TieringCostSavingInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeTieringCostSavingInfo(document.RootElement, options);
        }

        internal static TieringCostSavingInfo DeserializeTieringCostSavingInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long sourceTierSizeReductionInBytes = default;
            long targetTierSizeIncreaseInBytes = default;
            double retailSourceTierCostPerGBPerMonth = default;
            double retailTargetTierCostPerGBPerMonth = default;
            string objectType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sourceTierSizeReductionInBytes"u8))
                {
                    sourceTierSizeReductionInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("targetTierSizeIncreaseInBytes"u8))
                {
                    targetTierSizeIncreaseInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("retailSourceTierCostPerGBPerMonth"u8))
                {
                    retailSourceTierCostPerGBPerMonth = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("retailTargetTierCostPerGBPerMonth"u8))
                {
                    retailTargetTierCostPerGBPerMonth = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("objectType"u8))
                {
                    objectType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new TieringCostSavingInfo(
                objectType,
                serializedAdditionalRawData,
                sourceTierSizeReductionInBytes,
                targetTierSizeIncreaseInBytes,
                retailSourceTierCostPerGBPerMonth,
                retailTargetTierCostPerGBPerMonth);
        }

        BinaryData IPersistableModel<TieringCostSavingInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TieringCostSavingInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(TieringCostSavingInfo)} does not support writing '{options.Format}' format.");
            }
        }

        TieringCostSavingInfo IPersistableModel<TieringCostSavingInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TieringCostSavingInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeTieringCostSavingInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(TieringCostSavingInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<TieringCostSavingInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
