// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    public partial class TieringCostRehydrationInfo : IUtf8JsonSerializable, IJsonModel<TieringCostRehydrationInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<TieringCostRehydrationInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<TieringCostRehydrationInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TieringCostRehydrationInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TieringCostRehydrationInfo)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("rehydrationSizeInBytes"u8);
            writer.WriteNumberValue(RehydrationSizeInBytes);
            writer.WritePropertyName("retailRehydrationCostPerGBPerMonth"u8);
            writer.WriteNumberValue(RetailRehydrationCostPerGBPerMonth);
        }

        TieringCostRehydrationInfo IJsonModel<TieringCostRehydrationInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TieringCostRehydrationInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TieringCostRehydrationInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeTieringCostRehydrationInfo(document.RootElement, options);
        }

        internal static TieringCostRehydrationInfo DeserializeTieringCostRehydrationInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long rehydrationSizeInBytes = default;
            double retailRehydrationCostPerGBPerMonth = default;
            string objectType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("rehydrationSizeInBytes"u8))
                {
                    rehydrationSizeInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("retailRehydrationCostPerGBPerMonth"u8))
                {
                    retailRehydrationCostPerGBPerMonth = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("objectType"u8))
                {
                    objectType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new TieringCostRehydrationInfo(objectType, serializedAdditionalRawData, rehydrationSizeInBytes, retailRehydrationCostPerGBPerMonth);
        }

        BinaryData IPersistableModel<TieringCostRehydrationInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TieringCostRehydrationInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(TieringCostRehydrationInfo)} does not support writing '{options.Format}' format.");
            }
        }

        TieringCostRehydrationInfo IPersistableModel<TieringCostRehydrationInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TieringCostRehydrationInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeTieringCostRehydrationInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(TieringCostRehydrationInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<TieringCostRehydrationInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
