// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Target Azure File Share Info. </summary>
    public partial class TargetAfsRestoreInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TargetAfsRestoreInfo"/>. </summary>
        public TargetAfsRestoreInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TargetAfsRestoreInfo"/>. </summary>
        /// <param name="name"> File share name. </param>
        /// <param name="targetResourceId"> Target file share resource ARM ID. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TargetAfsRestoreInfo(string name, ResourceIdentifier targetResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            TargetResourceId = targetResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> File share name. </summary>
        public string Name { get; set; }
        /// <summary> Target file share resource ARM ID. </summary>
        public ResourceIdentifier TargetResourceId { get; set; }
    }
}
