// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Type of backup policy type. </summary>
    public readonly partial struct SubProtectionPolicyType : IEquatable<SubProtectionPolicyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SubProtectionPolicyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SubProtectionPolicyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string FullValue = "Full";
        private const string DifferentialValue = "Differential";
        private const string LogValue = "Log";
        private const string CopyOnlyFullValue = "CopyOnlyFull";
        private const string IncrementalValue = "Incremental";
        private const string SnapshotFullValue = "SnapshotFull";
        private const string SnapshotCopyOnlyFullValue = "SnapshotCopyOnlyFull";

        /// <summary> Invalid. </summary>
        public static SubProtectionPolicyType Invalid { get; } = new SubProtectionPolicyType(InvalidValue);
        /// <summary> Full. </summary>
        public static SubProtectionPolicyType Full { get; } = new SubProtectionPolicyType(FullValue);
        /// <summary> Differential. </summary>
        public static SubProtectionPolicyType Differential { get; } = new SubProtectionPolicyType(DifferentialValue);
        /// <summary> Log. </summary>
        public static SubProtectionPolicyType Log { get; } = new SubProtectionPolicyType(LogValue);
        /// <summary> CopyOnlyFull. </summary>
        public static SubProtectionPolicyType CopyOnlyFull { get; } = new SubProtectionPolicyType(CopyOnlyFullValue);
        /// <summary> Incremental. </summary>
        public static SubProtectionPolicyType Incremental { get; } = new SubProtectionPolicyType(IncrementalValue);
        /// <summary> SnapshotFull. </summary>
        public static SubProtectionPolicyType SnapshotFull { get; } = new SubProtectionPolicyType(SnapshotFullValue);
        /// <summary> SnapshotCopyOnlyFull. </summary>
        public static SubProtectionPolicyType SnapshotCopyOnlyFull { get; } = new SubProtectionPolicyType(SnapshotCopyOnlyFullValue);
        /// <summary> Determines if two <see cref="SubProtectionPolicyType"/> values are the same. </summary>
        public static bool operator ==(SubProtectionPolicyType left, SubProtectionPolicyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SubProtectionPolicyType"/> values are not the same. </summary>
        public static bool operator !=(SubProtectionPolicyType left, SubProtectionPolicyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SubProtectionPolicyType"/>. </summary>
        public static implicit operator SubProtectionPolicyType(string value) => new SubProtectionPolicyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SubProtectionPolicyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SubProtectionPolicyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
