// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Sub-protection policy which includes schedule and retention. </summary>
    public partial class SubProtectionPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SubProtectionPolicy"/>. </summary>
        public SubProtectionPolicy()
        {
            TieringPolicy = new ChangeTrackingDictionary<string, BackupTieringPolicy>();
        }

        /// <summary> Initializes a new instance of <see cref="SubProtectionPolicy"/>. </summary>
        /// <param name="policyType"> Type of backup policy type. </param>
        /// <param name="schedulePolicy">
        /// Backup schedule specified as part of backup policy.
        /// Please note <see cref="BackupSchedulePolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LogSchedulePolicy"/>, <see cref="LongTermSchedulePolicy"/>, <see cref="SimpleSchedulePolicy"/> and <see cref="SimpleSchedulePolicyV2"/>.
        /// </param>
        /// <param name="retentionPolicy">
        /// Retention policy with the details on backup copy retention ranges.
        /// Please note <see cref="BackupRetentionPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LongTermRetentionPolicy"/> and <see cref="SimpleRetentionPolicy"/>.
        /// </param>
        /// <param name="tieringPolicy">
        /// Tiering policy to automatically move RPs to another tier.
        /// Key is Target Tier, defined in RecoveryPointTierType enum.
        /// Tiering policy specifies the criteria to move RP to the target tier.
        /// </param>
        /// <param name="snapshotBackupAdditionalDetails"> Snapshot Backup related fields for WorkloadType SaPHanaSystem. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SubProtectionPolicy(SubProtectionPolicyType? policyType, BackupSchedulePolicy schedulePolicy, BackupRetentionPolicy retentionPolicy, IDictionary<string, BackupTieringPolicy> tieringPolicy, SnapshotBackupAdditionalDetails snapshotBackupAdditionalDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PolicyType = policyType;
            SchedulePolicy = schedulePolicy;
            RetentionPolicy = retentionPolicy;
            TieringPolicy = tieringPolicy;
            SnapshotBackupAdditionalDetails = snapshotBackupAdditionalDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of backup policy type. </summary>
        public SubProtectionPolicyType? PolicyType { get; set; }
        /// <summary>
        /// Backup schedule specified as part of backup policy.
        /// Please note <see cref="BackupSchedulePolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LogSchedulePolicy"/>, <see cref="LongTermSchedulePolicy"/>, <see cref="SimpleSchedulePolicy"/> and <see cref="SimpleSchedulePolicyV2"/>.
        /// </summary>
        public BackupSchedulePolicy SchedulePolicy { get; set; }
        /// <summary>
        /// Retention policy with the details on backup copy retention ranges.
        /// Please note <see cref="BackupRetentionPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LongTermRetentionPolicy"/> and <see cref="SimpleRetentionPolicy"/>.
        /// </summary>
        public BackupRetentionPolicy RetentionPolicy { get; set; }
        /// <summary>
        /// Tiering policy to automatically move RPs to another tier.
        /// Key is Target Tier, defined in RecoveryPointTierType enum.
        /// Tiering policy specifies the criteria to move RP to the target tier.
        /// </summary>
        public IDictionary<string, BackupTieringPolicy> TieringPolicy { get; }
        /// <summary> Snapshot Backup related fields for WorkloadType SaPHanaSystem. </summary>
        public SnapshotBackupAdditionalDetails SnapshotBackupAdditionalDetails { get; set; }
    }
}
