// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Encapsulates information regarding data directory. </summary>
    public partial class SqlDataDirectoryMapping
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlDataDirectoryMapping"/>. </summary>
        public SqlDataDirectoryMapping()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlDataDirectoryMapping"/>. </summary>
        /// <param name="mappingType"> Type of data directory mapping. </param>
        /// <param name="sourceLogicalName"> Restore source logical name path. </param>
        /// <param name="sourcePath"> Restore source path. </param>
        /// <param name="targetPath"> Target path. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlDataDirectoryMapping(SqlDataDirectoryType? mappingType, string sourceLogicalName, string sourcePath, string targetPath, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MappingType = mappingType;
            SourceLogicalName = sourceLogicalName;
            SourcePath = sourcePath;
            TargetPath = targetPath;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of data directory mapping. </summary>
        public SqlDataDirectoryType? MappingType { get; set; }
        /// <summary> Restore source logical name path. </summary>
        public string SourceLogicalName { get; set; }
        /// <summary> Restore source path. </summary>
        public string SourcePath { get; set; }
        /// <summary> Target path. </summary>
        public string TargetPath { get; set; }
    }
}
