// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> SQLDataDirectory info. </summary>
    public partial class SqlDataDirectory
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlDataDirectory"/>. </summary>
        public SqlDataDirectory()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlDataDirectory"/>. </summary>
        /// <param name="directoryType"> Type of data directory mapping. </param>
        /// <param name="path"> File path. </param>
        /// <param name="logicalName"> Logical name of the file. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlDataDirectory(SqlDataDirectoryType? directoryType, string path, string logicalName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DirectoryType = directoryType;
            Path = path;
            LogicalName = logicalName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of data directory mapping. </summary>
        public SqlDataDirectoryType? DirectoryType { get; set; }
        /// <summary> File path. </summary>
        public string Path { get; set; }
        /// <summary> Logical name of the file. </summary>
        public string LogicalName { get; set; }
    }
}
