// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Encapsulates information regarding snapshot recovery for SAP Hana. </summary>
    public partial class SnapshotRestoreContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SnapshotRestoreContent"/>. </summary>
        public SnapshotRestoreContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SnapshotRestoreContent"/>. </summary>
        /// <param name="skipAttachAndMount"></param>
        /// <param name="logPointInTimeForDBRecovery"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SnapshotRestoreContent(bool? skipAttachAndMount, string logPointInTimeForDBRecovery, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SkipAttachAndMount = skipAttachAndMount;
            LogPointInTimeForDBRecovery = logPointInTimeForDBRecovery;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the skip attach and mount. </summary>
        public bool? SkipAttachAndMount { get; set; }
        /// <summary> Gets or sets the log point in time for db recovery. </summary>
        public string LogPointInTimeForDBRecovery { get; set; }
    }
}
