// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Snapshot Backup related fields for WorkloadType SaPHanaSystem. </summary>
    public partial class SnapshotBackupAdditionalDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SnapshotBackupAdditionalDetails"/>. </summary>
        public SnapshotBackupAdditionalDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SnapshotBackupAdditionalDetails"/>. </summary>
        /// <param name="instantRpRetentionRangeInDays"></param>
        /// <param name="instantRPDetails"></param>
        /// <param name="userAssignedManagedIdentityDetails"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SnapshotBackupAdditionalDetails(int? instantRpRetentionRangeInDays, string instantRPDetails, UserAssignedManagedIdentityDetails userAssignedManagedIdentityDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InstantRpRetentionRangeInDays = instantRpRetentionRangeInDays;
            InstantRPDetails = instantRPDetails;
            UserAssignedManagedIdentityDetails = userAssignedManagedIdentityDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the instant rp retention range in days. </summary>
        public int? InstantRpRetentionRangeInDays { get; set; }
        /// <summary> Gets or sets the instant rp details. </summary>
        public string InstantRPDetails { get; set; }
        /// <summary> Gets or sets the user assigned managed identity details. </summary>
        public UserAssignedManagedIdentityDetails UserAssignedManagedIdentityDetails { get; set; }
    }
}
