// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Frequency of the schedule operation of this policy. </summary>
    public readonly partial struct ScheduleRunType : IEquatable<ScheduleRunType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScheduleRunType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScheduleRunType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string DailyValue = "Daily";
        private const string WeeklyValue = "Weekly";
        private const string HourlyValue = "Hourly";

        /// <summary> Invalid. </summary>
        public static ScheduleRunType Invalid { get; } = new ScheduleRunType(InvalidValue);
        /// <summary> Daily. </summary>
        public static ScheduleRunType Daily { get; } = new ScheduleRunType(DailyValue);
        /// <summary> Weekly. </summary>
        public static ScheduleRunType Weekly { get; } = new ScheduleRunType(WeeklyValue);
        /// <summary> Hourly. </summary>
        public static ScheduleRunType Hourly { get; } = new ScheduleRunType(HourlyValue);
        /// <summary> Determines if two <see cref="ScheduleRunType"/> values are the same. </summary>
        public static bool operator ==(ScheduleRunType left, ScheduleRunType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScheduleRunType"/> values are not the same. </summary>
        public static bool operator !=(ScheduleRunType left, ScheduleRunType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScheduleRunType"/>. </summary>
        public static implicit operator ScheduleRunType(string value) => new ScheduleRunType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScheduleRunType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScheduleRunType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
