// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Retention schedule format type for monthly retention policy. </summary>
    public readonly partial struct RetentionScheduleFormat : IEquatable<RetentionScheduleFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RetentionScheduleFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RetentionScheduleFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string DailyValue = "Daily";
        private const string WeeklyValue = "Weekly";

        /// <summary> Invalid. </summary>
        public static RetentionScheduleFormat Invalid { get; } = new RetentionScheduleFormat(InvalidValue);
        /// <summary> Daily. </summary>
        public static RetentionScheduleFormat Daily { get; } = new RetentionScheduleFormat(DailyValue);
        /// <summary> Weekly. </summary>
        public static RetentionScheduleFormat Weekly { get; } = new RetentionScheduleFormat(WeeklyValue);
        /// <summary> Determines if two <see cref="RetentionScheduleFormat"/> values are the same. </summary>
        public static bool operator ==(RetentionScheduleFormat left, RetentionScheduleFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RetentionScheduleFormat"/> values are not the same. </summary>
        public static bool operator !=(RetentionScheduleFormat left, RetentionScheduleFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RetentionScheduleFormat"/>. </summary>
        public static implicit operator RetentionScheduleFormat(string value) => new RetentionScheduleFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RetentionScheduleFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RetentionScheduleFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
