// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Type of restore point. </summary>
    public readonly partial struct RestorePointType : IEquatable<RestorePointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RestorePointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RestorePointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string FullValue = "Full";
        private const string LogValue = "Log";
        private const string DifferentialValue = "Differential";
        private const string IncrementalValue = "Incremental";
        private const string SnapshotFullValue = "SnapshotFull";
        private const string SnapshotCopyOnlyFullValue = "SnapshotCopyOnlyFull";

        /// <summary> Invalid. </summary>
        public static RestorePointType Invalid { get; } = new RestorePointType(InvalidValue);
        /// <summary> Full. </summary>
        public static RestorePointType Full { get; } = new RestorePointType(FullValue);
        /// <summary> Log. </summary>
        public static RestorePointType Log { get; } = new RestorePointType(LogValue);
        /// <summary> Differential. </summary>
        public static RestorePointType Differential { get; } = new RestorePointType(DifferentialValue);
        /// <summary> Incremental. </summary>
        public static RestorePointType Incremental { get; } = new RestorePointType(IncrementalValue);
        /// <summary> SnapshotFull. </summary>
        public static RestorePointType SnapshotFull { get; } = new RestorePointType(SnapshotFullValue);
        /// <summary> SnapshotCopyOnlyFull. </summary>
        public static RestorePointType SnapshotCopyOnlyFull { get; } = new RestorePointType(SnapshotCopyOnlyFullValue);
        /// <summary> Determines if two <see cref="RestorePointType"/> values are the same. </summary>
        public static bool operator ==(RestorePointType left, RestorePointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RestorePointType"/> values are not the same. </summary>
        public static bool operator !=(RestorePointType left, RestorePointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RestorePointType"/>. </summary>
        public static implicit operator RestorePointType(string value) => new RestorePointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RestorePointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RestorePointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
