// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Can Overwrite if Target DataBase already exists. </summary>
    public readonly partial struct RestoreOverwriteOption : IEquatable<RestoreOverwriteOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RestoreOverwriteOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RestoreOverwriteOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string FailOnConflictValue = "FailOnConflict";
        private const string OverwriteValue = "Overwrite";

        /// <summary> Invalid. </summary>
        public static RestoreOverwriteOption Invalid { get; } = new RestoreOverwriteOption(InvalidValue);
        /// <summary> FailOnConflict. </summary>
        public static RestoreOverwriteOption FailOnConflict { get; } = new RestoreOverwriteOption(FailOnConflictValue);
        /// <summary> Overwrite. </summary>
        public static RestoreOverwriteOption Overwrite { get; } = new RestoreOverwriteOption(OverwriteValue);
        /// <summary> Determines if two <see cref="RestoreOverwriteOption"/> values are the same. </summary>
        public static bool operator ==(RestoreOverwriteOption left, RestoreOverwriteOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RestoreOverwriteOption"/> values are not the same. </summary>
        public static bool operator !=(RestoreOverwriteOption left, RestoreOverwriteOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RestoreOverwriteOption"/>. </summary>
        public static implicit operator RestoreOverwriteOption(string value) => new RestoreOverwriteOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RestoreOverwriteOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RestoreOverwriteOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
