// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    /// <summary> Rehydration Priority. </summary>
    public readonly partial struct RehydrationPriority : IEquatable<RehydrationPriority>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RehydrationPriority"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RehydrationPriority(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string HighValue = "High";

        /// <summary> Standard. </summary>
        public static RehydrationPriority Standard { get; } = new RehydrationPriority(StandardValue);
        /// <summary> High. </summary>
        public static RehydrationPriority High { get; } = new RehydrationPriority(HighValue);
        /// <summary> Determines if two <see cref="RehydrationPriority"/> values are the same. </summary>
        public static bool operator ==(RehydrationPriority left, RehydrationPriority right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RehydrationPriority"/> values are not the same. </summary>
        public static bool operator !=(RehydrationPriority left, RehydrationPriority right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RehydrationPriority"/>. </summary>
        public static implicit operator RehydrationPriority(string value) => new RehydrationPriority(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RehydrationPriority other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RehydrationPriority other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
