// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.RecoveryServicesBackup.Models
{
    internal static partial class RecoveryPointTierTypeExtensions
    {
        public static string ToSerialString(this RecoveryPointTierType value) => value switch
        {
            RecoveryPointTierType.Invalid => "Invalid",
            RecoveryPointTierType.InstantRP => "InstantRP",
            RecoveryPointTierType.HardenedRP => "HardenedRP",
            RecoveryPointTierType.ArchivedRP => "ArchivedRP",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RecoveryPointTierType value.")
        };

        public static RecoveryPointTierType ToRecoveryPointTierType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Invalid")) return RecoveryPointTierType.Invalid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "InstantRP")) return RecoveryPointTierType.InstantRP;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "HardenedRP")) return RecoveryPointTierType.HardenedRP;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ArchivedRP")) return RecoveryPointTierType.ArchivedRP;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RecoveryPointTierType value.");
        }
    }
}
